/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.ganymed;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.engine.ganymed.GanymedUtil;

public class GanymedSession
implements Session {
    private Connection connection;
    private final ch.ethz.ssh2.Session raw;
    private Map<String, LocalPortForwarder> localPortForwarderMap;

    public GanymedSession(Connector connector) {
        this(GanymedUtil.openConnection(connector));
    }

    public GanymedSession(Connection connection) {
        this(GanymedUtil.openSession(connection));
        this.connection = connection;
    }

    private GanymedSession(ch.ethz.ssh2.Session raw) {
        this.raw = raw;
    }

    public ch.ethz.ssh2.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.raw != null) {
            this.raw.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IORuntimeException {
        LocalPortForwarder localPortForwarder;
        try {
            localPortForwarder = this.connection.createLocalPortForwarder(localAddress, remoteAddress.getHostName(), remoteAddress.getPort());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        if (null == this.localPortForwarderMap) {
            this.localPortForwarderMap = new HashMap<String, LocalPortForwarder>();
        }
        this.localPortForwarderMap.put(localAddress.toString(), localPortForwarder);
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) throws IORuntimeException {
        if (MapUtil.isEmpty(this.localPortForwarderMap)) {
            return;
        }
        LocalPortForwarder localPortForwarder = this.localPortForwarderMap.remove(localAddress.toString());
        if (null != localPortForwarder) {
            try {
                localPortForwarder.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IORuntimeException {
        try {
            this.connection.requestRemotePortForwarding(remoteAddress.getHostName(), remoteAddress.getPort(), localAddress.getHostName(), localAddress.getPort());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) throws IORuntimeException {
        try {
            this.connection.cancelRemotePortForwarding(remoteAddress.getPort());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            this.raw.execCommand(cmd, charset.name());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        if (null != errStream) {
            IoUtil.copy((InputStream)new StreamGobbler(this.raw.getStderr()), (OutputStream)errStream);
        }
        return IoUtil.read((InputStream)new StreamGobbler(this.raw.getStdout()), (Charset)charset);
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            this.raw.requestDumbPTY();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        IoUtil.write((OutputStream)this.raw.getStdin(), (Charset)charset, (boolean)true, (Object[])new Object[]{cmd});
        if (null != errStream) {
            IoUtil.copy((InputStream)new StreamGobbler(this.raw.getStderr()), (OutputStream)errStream);
        }
        return IoUtil.read((InputStream)new StreamGobbler(this.raw.getStdout()), (Charset)charset);
    }
}

