/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.resolve.DirectoryCodeResolver;
import gg.jte.resolve.ResourceCodeResolver;
import java.nio.file.Paths;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.jte.JteTemplate;
import org.dromara.hutool.extra.template.engine.jte.SimpleStringCodeResolver;

public class JteEngine
implements TemplateEngine {
    private final ContentType contentType = ContentType.Plain;
    private TemplateConfig config = TemplateConfig.DEFAULT;
    private gg.jte.TemplateEngine engine;

    public JteEngine() {
    }

    public JteEngine(TemplateConfig config) {
        this.config = config;
        this.createEngine();
    }

    public JteEngine(CodeResolver codeResolver) {
        this.engine = this.createEngine(codeResolver);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (config != null) {
            this.config = config;
        }
        this.createEngine();
        return this;
    }

    @Override
    public Template getTemplate(String resource) {
        if (TemplateConfig.ResourceMode.STRING.equals((Object)this.config.getResourceMode())) {
            String path = this.config.getPath();
            if (!StrUtil.endWithAny((CharSequence)path, (CharSequence[])new CharSequence[]{".jte", ".kte"})) {
                path = StrUtil.addSuffixIfNot((CharSequence)StrUtil.defaultIfEmpty((CharSequence)path, (CharSequence)"hutool"), (CharSequence)".jte");
            }
            return new JteTemplate(this.createEngine(new SimpleStringCodeResolver(MapUtil.of((Object)path, (Object)resource))), path, this.config.getCharset());
        }
        return new JteTemplate(this.engine, resource, this.config.getCharset());
    }

    public gg.jte.TemplateEngine getRaw() {
        return this.engine;
    }

    private void createEngine() {
        switch (this.config.getResourceMode()) {
            case CLASSPATH: {
                this.engine = this.createEngine((CodeResolver)new ResourceCodeResolver(this.config.getPath(), JteEngine.class.getClassLoader()));
                break;
            }
            case FILE: {
                this.engine = this.createEngine((CodeResolver)new DirectoryCodeResolver(Paths.get(this.config.getPath(), new String[0])));
                break;
            }
            case STRING: {
                break;
            }
        }
    }

    private gg.jte.TemplateEngine createEngine(CodeResolver codeResolver) {
        return gg.jte.TemplateEngine.create((CodeResolver)codeResolver, (ContentType)this.contentType);
    }
}

