/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.validation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.extra.validation.BeanValidationResult;

public class ValidationUtil {
    private static final Validator validator;

    public static Validator getValidator() {
        return validator;
    }

    public static <T> Set<ConstraintViolation<T>> validate(T bean, Class<?> ... groups) {
        return validator.validate(bean, (Class[])groups);
    }

    public static void validateAndThrowFirst(Object object, Class<?> ... groups) throws ValidationException {
        Set<ConstraintViolation<Object>> constraintViolations = ValidationUtil.validate(object, groups);
        if (CollUtil.isNotEmpty(constraintViolations)) {
            ConstraintViolation<Object> constraint = constraintViolations.iterator().next();
            throw new ValidationException(constraint.getMessage());
        }
    }

    public static <T> Set<ConstraintViolation<T>> validateProperty(T bean, String propertyName, Class<?> ... groups) {
        return validator.validateProperty(bean, propertyName, (Class[])groups);
    }

    public static <T> BeanValidationResult warpValidate(T bean, Class<?> ... groups) {
        return ValidationUtil.warpBeanValidationResult(ValidationUtil.validate(bean, groups));
    }

    public static <T> BeanValidationResult warpValidateProperty(T bean, String propertyName, Class<?> ... groups) {
        return ValidationUtil.warpBeanValidationResult(ValidationUtil.validateProperty(bean, propertyName, groups));
    }

    private static <T> BeanValidationResult warpBeanValidationResult(Set<ConstraintViolation<T>> constraintViolations) {
        BeanValidationResult result = new BeanValidationResult(constraintViolations.isEmpty());
        for (ConstraintViolation<T> constraintViolation : constraintViolations) {
            BeanValidationResult.ErrorMessage errorMessage = new BeanValidationResult.ErrorMessage();
            errorMessage.setPropertyName(constraintViolation.getPropertyPath().toString());
            errorMessage.setMessage(constraintViolation.getMessage());
            errorMessage.setValue(constraintViolation.getInvalidValue());
            result.addErrorMessage(errorMessage);
        }
        return result;
    }

    static {
        try (ValidatorFactory factory = Validation.buildDefaultValidatorFactory();){
            validator = factory.getValidator();
        }
    }
}

