/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.SshException;
import org.dromara.hutool.extra.ssh.engine.jsch.ChannelType;

public class JschUtil {
    public static Session openSession(Connector connector) {
        Session session;
        JSch jsch = new JSch();
        try {
            session = jsch.getSession(connector.getUser(), connector.getHost(), connector.getPort());
            session.setTimeout((int)connector.getTimeout());
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
        session.setPassword(connector.getPassword());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        return session;
    }

    public static Channel openChannel(Session session, ChannelType channelType, long timeout) {
        Channel channel = JschUtil.createChannel(session, channelType, timeout);
        try {
            channel.connect((int)Math.max(timeout, 0L));
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
        return channel;
    }

    public static Channel createChannel(Session session, ChannelType channelType, long timeout) {
        Channel channel;
        try {
            if (!session.isConnected()) {
                session.connect((int)timeout);
            }
            channel = session.openChannel(channelType.getValue());
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
        return channel;
    }

    public static void close(Session session) {
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
    }

    public static void close(Channel channel) {
        if (channel != null && channel.isConnected()) {
            channel.disconnect();
        }
    }
}

