/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.rythm;

import java.util.Properties;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.rythm.RythmTemplate;

public class RythmEngine
implements TemplateEngine {
    private org.rythmengine.RythmEngine engine;

    public RythmEngine() {
        Assert.notNull(org.rythmengine.RythmEngine.class);
    }

    public RythmEngine(TemplateConfig config) {
        this.init(config);
    }

    public RythmEngine(org.rythmengine.RythmEngine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(RythmEngine.createEngine(config));
        return this;
    }

    private void init(org.rythmengine.RythmEngine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        return RythmTemplate.wrap(this.engine.getTemplate(resource, new Object[0]));
    }

    public org.rythmengine.RythmEngine getRaw() {
        return this.engine;
    }

    private static org.rythmengine.RythmEngine createEngine(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Properties props = new Properties();
        String path = config.getPath();
        if (null != path) {
            props.put("home.template", path);
        }
        return new org.rythmengine.RythmEngine(props);
    }
}

