/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.tokenizer.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.tokenizer.TokenizerException;
import org.dromara.hutool.extra.tokenizer.engine.TokenizerEngine;
import org.dromara.hutool.log.LogUtil;

public class TokenizerEngineFactory {
    public static TokenizerEngine getEngine() {
        TokenizerEngine engine = (TokenizerEngine)Singleton.get((String)TokenizerEngine.class.getName(), TokenizerEngineFactory::createEngine);
        LogUtil.debug((String)"Use [{}] Tokenizer Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    public static TokenizerEngine createEngine() {
        return TokenizerEngineFactory.doCreateEngine();
    }

    public static TokenizerEngine createEngine(String engineName) throws TokenizerException {
        if (!StrUtil.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader list = SpiUtil.loadList(TokenizerEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (TokenizerEngine)list.getService(serviceName);
        }
        throw new TokenizerException("No such engine named: " + engineName);
    }

    private static TokenizerEngine doCreateEngine() {
        TokenizerEngine engine = (TokenizerEngine)SpiUtil.loadFirstAvailable(TokenizerEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TokenizerException("No tokenizer found !Please add some tokenizer jar to your project !");
    }
}

