/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh;

import com.jcraft.jsch.Session;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dromara.hutool.core.cache.SimpleCache;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.ssh.JschUtil;

public enum JschSessionPool {
    INSTANCE;

    private final SimpleCache<String, Session> cache = new SimpleCache(new HashMap());

    public Session get(String key) {
        return (Session)this.cache.get((Object)key);
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StrUtil.format((CharSequence)"{}@{}:{}", (Object[])new Object[]{sshUser, sshHost, sshPort});
        return (Session)this.cache.get((Object)key, Session::isConnected, (SerSupplier & Serializable)() -> JschUtil.openSession(sshHost, sshPort, sshUser, sshPass));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String prvkey, byte[] passphrase) {
        String key = StrUtil.format((CharSequence)"{}@{}:{}", (Object[])new Object[]{sshUser, sshHost, sshPort});
        return (Session)this.cache.get((Object)key, Session::isConnected, (SerSupplier & Serializable)() -> JschUtil.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public void put(String key, Session session) {
        this.cache.put((Object)key, (Object)session);
    }

    public void close(String key) {
        Session session = this.get(key);
        if (session != null && session.isConnected()) {
            session.disconnect();
        }
        this.cache.remove((Object)key);
    }

    public void remove(Session session) {
        if (null != session) {
            Iterator iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!session.equals(entry.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void closeAll() {
        for (Map.Entry entry : this.cache) {
            Session session = (Session)entry.getValue();
            if (session == null || !session.isConnected()) continue;
            session.disconnect();
        }
        this.cache.clear();
    }
}

