/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.tokenizer.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.tokenizer.TokenizerException;
import org.dromara.hutool.extra.tokenizer.engine.TokenizerEngine;
import org.dromara.hutool.log.LogUtil;

public class TokenizerEngineFactory {
    public static TokenizerEngine getEngine() {
        return (TokenizerEngine)Singleton.get((String)TokenizerEngine.class.getName(), TokenizerEngineFactory::createEngine);
    }

    public static TokenizerEngine createEngine() {
        TokenizerEngine engine = TokenizerEngineFactory.doCreateEngine();
        LogUtil.debug((String)"Use [{}] Tokenizer Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static TokenizerEngine doCreateEngine() {
        TokenizerEngine engine = (TokenizerEngine)SpiUtil.loadFirstAvailable(TokenizerEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TokenizerException("No tokenizer found !Please add some tokenizer jar to your project !");
    }
}

