/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.management;

import java.io.File;
import java.io.Serializable;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.SystemUtil;
import org.dromara.hutool.extra.management.ManagementUtil;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String USER_NAME = UserInfo.fixPath(SystemUtil.get((String)"user.name", (boolean)false));
    private final String USER_HOME = UserInfo.fixPath(SystemUtil.get((String)"user.home", (boolean)false));
    private final String USER_DIR = UserInfo.fixPath(SystemUtil.get((String)"user.dir", (boolean)false));
    private final String JAVA_IO_TMPDIR = UserInfo.fixPath(SystemUtil.get((String)"java.io.tmpdir", (boolean)false));
    private final String USER_LANGUAGE = SystemUtil.get((String)"user.language", (boolean)false);
    private final String USER_COUNTRY;

    public UserInfo() {
        String userCountry = SystemUtil.get((String)"user.country", (boolean)false);
        if (null == userCountry) {
            userCountry = SystemUtil.get((String)"user.region", (boolean)false);
        }
        this.USER_COUNTRY = userCountry;
    }

    public final String getName() {
        return this.USER_NAME;
    }

    public final String getHomeDir() {
        return this.USER_HOME;
    }

    public final String getCurrentDir() {
        return this.USER_DIR;
    }

    public final String getTempDir() {
        return this.JAVA_IO_TMPDIR;
    }

    public final String getLanguage() {
        return this.USER_LANGUAGE;
    }

    public final String getCountry() {
        return this.USER_COUNTRY;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        ManagementUtil.append(builder, "User Name:        ", this.getName());
        ManagementUtil.append(builder, "User Home Dir:    ", this.getHomeDir());
        ManagementUtil.append(builder, "User Current Dir: ", this.getCurrentDir());
        ManagementUtil.append(builder, "User Temp Dir:    ", this.getTempDir());
        ManagementUtil.append(builder, "User Language:    ", this.getLanguage());
        ManagementUtil.append(builder, "User Country:     ", this.getCountry());
        return builder.toString();
    }

    private static String fixPath(String path) {
        return StrUtil.addSuffixIfNot((CharSequence)path, (CharSequence)File.separator);
    }
}

