/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.jsch;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.SshException;
import org.dromara.hutool.extra.ssh.engine.jsch.ChannelType;
import org.dromara.hutool.extra.ssh.engine.jsch.JschSftp;
import org.dromara.hutool.extra.ssh.engine.jsch.JschUtil;

public class JschSession
implements Session {
    private final com.jcraft.jsch.Session raw;
    private final long timeout;

    public JschSession(Connector connector) {
        this(JschUtil.openSession(connector), connector.getTimeout());
    }

    public JschSession(com.jcraft.jsch.Session raw, long timeout) {
        this.raw = raw;
        this.timeout = timeout;
    }

    public com.jcraft.jsch.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && this.raw.isConnected();
    }

    @Override
    public void close() throws IOException {
        JschUtil.close(this.raw);
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, int localPort) throws SshException {
        return this.bindLocalPort(remoteHost, remotePort, "127.0.0.1", localPort);
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, String localHost, int localPort) throws SshException {
        if (this.isConnected()) {
            try {
                this.raw.setPortForwardingL(localHost, localPort, remoteHost, remotePort);
            }
            catch (JSchException e) {
                throw new SshException(e, "From [{}:{}] mapping to [{}:{}] error\uff01", remoteHost, remotePort, localHost, localPort);
            }
            return true;
        }
        return false;
    }

    public void unBindLocalPort(int localPort) {
        try {
            this.raw.delPortForwardingL(localPort);
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
    }

    public boolean bindRemotePort(int bindPort, String host, int port) throws SshException {
        if (this.isConnected()) {
            try {
                this.raw.setPortForwardingR(bindPort, host, port);
            }
            catch (JSchException e) {
                throw new SshException(e, "From [{}] mapping to [{}] error\uff01", bindPort, port);
            }
            return true;
        }
        return false;
    }

    public void unBindRemotePort(int localPort) {
        try {
            this.raw.delPortForwardingR(localPort);
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
    }

    public Channel createChannel(ChannelType channelType) {
        return JschUtil.createChannel(this.raw, channelType, this.timeout);
    }

    public ChannelShell openShell() {
        return (ChannelShell)this.openChannel(ChannelType.SHELL);
    }

    public Channel openChannel(ChannelType channelType) {
        return JschUtil.openChannel(this.raw, channelType, this.timeout);
    }

    public JschSftp openSftp(Charset charset) {
        return new JschSftp(this.raw, charset, this.timeout);
    }

    public String exec(String cmd, Charset charset) {
        return this.exec(cmd, charset, System.err);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exec(String cmd, Charset charset, OutputStream errStream) {
        String string;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        ChannelExec channel = (ChannelExec)this.createChannel(ChannelType.EXEC);
        channel.setCommand(ByteUtil.toBytes((CharSequence)cmd, (Charset)charset));
        channel.setInputStream(null);
        channel.setErrStream(errStream);
        InputStream in = null;
        try {
            channel.connect();
            in = channel.getInputStream();
            string = IoUtil.read((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
                catch (JSchException e2) {
                    throw new SshException(e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                if (channel.isConnected()) {
                    channel.disconnect();
                }
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        if (channel.isConnected()) {
            channel.disconnect();
        }
        return string;
    }

    public String execByShell(String cmd, Charset charset) {
        String string;
        ChannelShell shell = this.openShell();
        shell.setPty(true);
        OutputStream out = null;
        InputStream in = null;
        try {
            out = shell.getOutputStream();
            in = shell.getInputStream();
            out.write(ByteUtil.toBytes((CharSequence)cmd, (Charset)charset));
            out.flush();
            string = IoUtil.read((InputStream)in, (Charset)charset);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                if (shell.isConnected()) {
                    shell.disconnect();
                }
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        if (shell.isConnected()) {
            shell.disconnect();
        }
        return string;
    }
}

