/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.engine.mina.MinaUtil;

public class MinaSession
implements Session {
    private final SshClient sshClient = MinaUtil.openClient();
    private final ClientSession raw;

    public MinaSession(Connector connector) {
        this.raw = MinaUtil.openSession(this.sshClient, connector);
    }

    public Object getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && this.raw.isOpen();
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.raw});
        if (null != this.sshClient) {
            this.sshClient.stop();
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sshClient});
    }

    public String exec(String cmd, Charset charset) {
        return this.exec(cmd, charset, System.err);
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        try {
            return this.raw.executeRemoteCommand(cmd, errStream, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        ChannelShell shellChannel;
        try {
            shellChannel = this.raw.createShellChannel();
            if (null != errStream) {
                shellChannel.setErr(errStream);
            }
            shellChannel.open().verify(new CancelOption[0]);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        IoUtil.write((OutputStream)shellChannel.getInvertedIn(), (Charset)charset, (boolean)false, (Object[])new Object[]{cmd});
        return IoUtil.read((InputStream)shellChannel.getInvertedOut(), (Charset)charset);
    }
}

