/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.sshj;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.SocketForwardingConnectListener;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.SshException;
import org.dromara.hutool.extra.ssh.engine.sshj.SshjSftp;
import org.dromara.hutool.extra.ssh.engine.sshj.SshjUtil;

public class SshjSession
implements Session {
    private SSHClient ssh;
    private final net.schmizz.sshj.connection.channel.direct.Session raw;
    private Map<Integer, ServerSocket> localPortForwarderMap;

    public SshjSession(Connector connector) {
        this(SshjUtil.openClient(connector));
    }

    public SshjSession(SSHClient ssh) {
        this.ssh = ssh;
        try {
            this.raw = ssh.startSession();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public net.schmizz.sshj.connection.channel.direct.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && (null == this.ssh || this.ssh.isConnected());
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.raw});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.ssh});
    }

    public SshjSftp openSftp(Charset charset) {
        return new SshjSftp(this.ssh, charset);
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, int localPort) throws SshException {
        return this.bindLocalPort(remoteHost, remotePort, "127.0.0.1", localPort);
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, String localHost, int localPort) throws IORuntimeException {
        ServerSocket ss;
        Parameters params = new Parameters(localHost, localPort, remoteHost, remotePort);
        try {
            ss = new ServerSocket();
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(params.getLocalHost(), params.getLocalPort()));
            this.ssh.newLocalPortForwarder(params, ss).listen();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        if (null == this.localPortForwarderMap) {
            this.localPortForwarderMap = new HashMap<Integer, ServerSocket>();
        }
        this.localPortForwarderMap.put(localPort, ss);
        return true;
    }

    public void unBindLocalPort(int localPort) throws IORuntimeException {
        if (MapUtil.isEmpty(this.localPortForwarderMap)) {
            return;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.localPortForwarderMap.remove(localPort)});
    }

    public boolean bindRemotePort(int bindPort, String host, int port) throws IORuntimeException {
        try {
            this.ssh.getRemotePortForwarder().bind(new RemotePortForwarder.Forward(bindPort), (ConnectListener)new SocketForwardingConnectListener((SocketAddress)new InetSocketAddress(host, port)));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return true;
    }

    public void unBindRemotePort(int localPort) {
        RemotePortForwarder remotePortForwarder = this.ssh.getRemotePortForwarder();
        Set activeForwards = remotePortForwarder.getActiveForwards();
        for (RemotePortForwarder.Forward activeForward : activeForwards) {
            if (localPort != activeForward.getPort()) continue;
            try {
                remotePortForwarder.cancel(activeForward);
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            return;
        }
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        Session.Command command;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            command = this.raw.exec(cmd);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        if (null != errStream) {
            IoUtil.copy((InputStream)command.getErrorStream(), (OutputStream)errStream);
        }
        return IoUtil.read((InputStream)command.getInputStream(), (Charset)charset);
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        Session.Shell shell;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            shell = this.raw.startShell();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        IoUtil.write((OutputStream)shell.getOutputStream(), (Charset)charset, (boolean)true, (Object[])new Object[]{cmd});
        if (null != errStream) {
            IoUtil.copy((InputStream)shell.getErrorStream(), (OutputStream)errStream);
        }
        return IoUtil.read((InputStream)shell.getInputStream(), (Charset)charset);
    }
}

