/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.compress.archiver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.compress.CompressException;
import org.dromara.hutool.extra.compress.archiver.Archiver;

public class StreamArchiver
implements Archiver {
    private final ArchiveOutputStream out;

    public static StreamArchiver of(Charset charset, String archiverName, File file) {
        return new StreamArchiver(charset, archiverName, file);
    }

    public static StreamArchiver of(Charset charset, String archiverName, OutputStream out) {
        return new StreamArchiver(charset, archiverName, out);
    }

    public StreamArchiver(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileUtil.getOutputStream((File)file));
    }

    public StreamArchiver(Charset charset, String archiverName, OutputStream targetStream) {
        if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
            try {
                this.out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream(targetStream));
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
            return;
        }
        ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
        try {
            this.out = factory.createArchiveOutputStream(archiverName, targetStream);
        }
        catch (ArchiveException e) {
            throw new CompressException(e);
        }
        if (this.out instanceof TarArchiveOutputStream) {
            ((TarArchiveOutputStream)this.out).setLongFileMode(2);
        } else if (this.out instanceof ArArchiveOutputStream) {
            ((ArArchiveOutputStream)this.out).setLongFileMode(1);
        }
    }

    @Override
    public StreamArchiver add(File file, String path, Predicate<File> predicate) throws IORuntimeException {
        try {
            this.addInternal(file, path, predicate);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public StreamArchiver finish() {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.out});
    }

    private void addInternal(File file, String path, Predicate<File> predicate) throws IOException {
        if (null != predicate && !predicate.test(file)) {
            return;
        }
        ArchiveOutputStream out = this.out;
        String entryName = StrUtil.isNotEmpty((CharSequence)path) ? StrUtil.addSuffixIfNot((CharSequence)path, (CharSequence)"/") + file.getName() : file.getName();
        out.putArchiveEntry(out.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayUtil.isNotEmpty((Object[])files)) {
                for (Object childFile : files) {
                    this.addInternal((File)childFile, entryName, predicate);
                }
            }
        } else {
            if (file.isFile()) {
                FileUtil.writeToStream((File)file, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
    }
}

