/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ftp;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ftp.FtpConfig;
import org.dromara.hutool.extra.ftp.FtpException;

public abstract class AbstractFtp
implements Closeable {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    protected FtpConfig ftpConfig;

    protected AbstractFtp(FtpConfig config) {
        this.ftpConfig = config;
    }

    public abstract AbstractFtp reconnectIfTimeout();

    public abstract boolean cd(String var1);

    public boolean toParent() {
        return this.cd("..");
    }

    public abstract String pwd();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDir(String dir) {
        String workDir = this.pwd();
        try {
            boolean bl = this.cd(dir);
            return bl;
        }
        finally {
            this.cd(workDir);
        }
    }

    public abstract boolean mkdir(String var1);

    public boolean exist(String path) {
        List<String> names;
        if (StrUtil.isBlank((CharSequence)path)) {
            return false;
        }
        if (this.isDir(path)) {
            return true;
        }
        if (CharUtil.isFileSeparator((char)path.charAt(path.length() - 1))) {
            return false;
        }
        String fileName = FileNameUtil.getName((String)path);
        if (".".equals(fileName) || "..".equals(fileName)) {
            return false;
        }
        String dir = (String)StrUtil.defaultIfEmpty((CharSequence)StrUtil.removeSuffix((CharSequence)path, (CharSequence)fileName), (CharSequence)".");
        try {
            names = this.ls(dir);
        }
        catch (FtpException ignore) {
            return false;
        }
        return AbstractFtp.containsIgnoreCase(names, fileName);
    }

    public abstract List<String> ls(String var1);

    public abstract boolean delFile(String var1);

    public abstract boolean delDir(String var1);

    public void mkDirs(String dir) {
        String[] dirs = StrUtil.trim((CharSequence)dir).split("[\\\\/]+");
        String now = this.pwd();
        if (dirs.length > 0 && StrUtil.isEmpty((CharSequence)dirs[0])) {
            this.cd("/");
        }
        for (String s : dirs) {
            if (!StrUtil.isNotEmpty((CharSequence)s)) continue;
            boolean exist = true;
            try {
                if (!this.cd(s)) {
                    exist = false;
                }
            }
            catch (FtpException e) {
                exist = false;
            }
            if (exist) continue;
            this.mkdir(s);
            this.cd(s);
        }
        this.cd(now);
    }

    public abstract boolean uploadFile(String var1, File var2);

    public abstract void download(String var1, File var2);

    public void download(String path, File outFile, String tempFileSuffix) {
        tempFileSuffix = StrUtil.isBlank((CharSequence)tempFileSuffix) ? ".temp" : StrUtil.addPrefixIfNot((CharSequence)tempFileSuffix, (CharSequence)".");
        String fileName = outFile.isDirectory() ? FileNameUtil.getName((String)path) : outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.isDirectory() ? outFile : outFile.getParentFile(), tempFileName);
        try {
            this.download(path, outFile);
            FileUtil.rename((File)outFile, (String)fileName, (boolean)true);
        }
        catch (Throwable e) {
            FileUtil.del((File)outFile);
            throw new FtpException(e);
        }
    }

    public abstract void recursiveDownloadFolder(String var1, File var2);

    private static boolean containsIgnoreCase(List<String> names, String nameToFind) {
        if (CollUtil.isEmpty(names)) {
            return false;
        }
        if (StrUtil.isEmpty((CharSequence)nameToFind)) {
            return false;
        }
        for (String name : names) {
            if (!nameToFind.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

