/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.pinyin.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.pinyin.PinyinException;
import org.dromara.hutool.extra.pinyin.engine.PinyinEngine;
import org.dromara.hutool.log.StaticLog;

public class PinyinEngineFactory {
    public static PinyinEngine getEngine() {
        return (PinyinEngine)Singleton.get((String)PinyinEngine.class.getName(), PinyinEngineFactory::createEngine);
    }

    public static PinyinEngine createEngine() {
        PinyinEngine engine = PinyinEngineFactory.doCreateEngine();
        StaticLog.debug((String)"Use [{}] Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }

    private static PinyinEngine doCreateEngine() {
        PinyinEngine engine = (PinyinEngine)SpiUtil.loadFirstAvailable(PinyinEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new PinyinException("No pinyin jar found !Please add one of it to your project !");
    }
}

