/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import java.io.File;
import java.io.IOException;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.TemplateException;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.freemarker.FreemarkerTemplate;
import org.dromara.hutool.extra.template.engine.freemarker.SimpleStringTemplateLoader;

public class FreemarkerEngine
implements TemplateEngine {
    private Configuration cfg;

    public FreemarkerEngine() {
    }

    public FreemarkerEngine(TemplateConfig config) {
        this.init(config);
    }

    public FreemarkerEngine(Configuration freemarkerCfg) {
        this.init(freemarkerCfg);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.init(FreemarkerEngine.createCfg(config));
        return this;
    }

    private void init(Configuration freemarkerCfg) {
        this.cfg = freemarkerCfg;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.cfg) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return FreemarkerTemplate.wrap(this.cfg.getTemplate(resource));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    public Configuration getRaw() {
        return this.cfg;
    }

    private static Configuration createCfg(TemplateConfig config) {
        if (null == config) {
            config = new TemplateConfig();
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setLocalizedLookup(false);
        cfg.setDefaultEncoding(config.getCharset().toString());
        switch (config.getResourceMode()) {
            case CLASSPATH: {
                cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ClassLoaderUtil.getClassLoader(), config.getPath()));
                break;
            }
            case FILE: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            case WEB_ROOT: {
                try {
                    cfg.setTemplateLoader((TemplateLoader)new FileTemplateLoader(FileUtil.file((File)FileUtil.getWebRoot(), (String)config.getPath())));
                    break;
                }
                catch (IOException e) {
                    throw new IORuntimeException((Throwable)e);
                }
            }
            case STRING: {
                cfg.setTemplateLoader((TemplateLoader)new SimpleStringTemplateLoader());
                break;
            }
        }
        return cfg;
    }
}

