/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.net.NetUtil;
import org.dromara.hutool.core.net.multipart.MultipartFormData;
import org.dromara.hutool.core.net.multipart.UploadSetting;
import org.dromara.hutool.core.net.url.UrlEncoder;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.Method;

public class JakartaServletUtil {
    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : JakartaServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBody(ServletRequest request) {
        try (BufferedReader reader = request.getReader();){
            String string = IoUtil.read((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst((CharSequence)bean.getClass().getSimpleName());
        return (T)BeanUtil.fillBean(bean, (ValueProvider)new ValueProvider<String>(){

            public Object value(String key, Type valueType) {
                Object[] values = request.getParameterValues(key);
                if (ArrayUtil.isEmpty((Object[])values) && ArrayUtil.isEmpty((Object[])(values = request.getParameterValues(beanName + "." + key)))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, (CopyOptions)copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return JakartaServletUtil.fillBean(request, bean, CopyOptions.of().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return (T)JakartaServletUtil.fillBean(request, ConstructorUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return JakartaServletUtil.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }

    public static MultipartFormData getMultipart(ServletRequest request) throws IORuntimeException {
        return JakartaServletUtil.getMultipart(request, new UploadSetting());
    }

    public static MultipartFormData getMultipart(ServletRequest request, UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream((InputStream)request.getInputStream(), CharsetUtil.charset((String)request.getCharacterEncoding()));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return formData;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    public static Map<String, List<String>> getHeadersMap(HttpServletRequest request) {
        LinkedHashMap<String, List<String>> headerMap = new LinkedHashMap<String, List<String>>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, ListUtil.of((Enumeration)request.getHeaders(name)));
        }
        return headerMap;
    }

    public static Map<String, Collection<String>> getHeadersMap(HttpServletResponse response) {
        HashMap<String, Collection<String>> headerMap = new HashMap<String, Collection<String>>();
        Collection names = response.getHeaderNames();
        for (String name : names) {
            headerMap.put(name, response.getHeaders(name));
        }
        return headerMap;
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String name, Charset charset) {
        String header = request.getHeader(name);
        if (null != header) {
            return CharsetUtil.convert((String)header, (Charset)CharsetUtil.ISO_8859_1, (Charset)charset);
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = JakartaServletUtil.getHeaderIgnoreCase(request, "User-Agent");
        if (StrUtil.isNotBlank((CharSequence)userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return Method.GET.name().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return Method.POST.name().equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!JakartaServletUtil.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        return JakartaServletUtil.readCookieMap(httpServletRequest).get(name);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        Object[] cookies = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty((Object[])cookies)) {
            return MapUtil.empty();
        }
        return MapUtil.putAll((Map)new CaseInsensitiveMap(), (Iterator)new ArrayIter((Object[])httpServletRequest.getCookies()), Cookie::getName);
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        JakartaServletUtil.addCookie(response, cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        JakartaServletUtil.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = (String)ObjUtil.defaultIfNull((Object)FileUtil.getMimeType((String)fileName), (Object)"application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            JakartaServletUtil.write(response, in, contentType, fileName);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = (String)ObjUtil.defaultIfNull((Object)response.getCharacterEncoding(), (Object)"UTF-8");
        String encodeText = UrlEncoder.encodeAll((String)fileName, (Charset)CharsetUtil.charset((String)charset));
        response.setHeader("Content-Disposition", StrUtil.format((CharSequence)"attachment;filename=\"{}\";filename*={}''{}", (Object[])new Object[]{encodeText, charset, encodeText}));
        response.setContentType(contentType);
        JakartaServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        JakartaServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        JakartaServletUtil.write(response, in, 8192);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtil.copy((InputStream)in, (OutputStream)out, (int)bufferSize);
        }
        catch (IOException e) {
            try {
                throw new HutoolException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equalsIgnoreCase(value.getClass().getSimpleName())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }
}

