/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.GlobalCompressStreamRegister;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpResponse;

public class JdkHttpInputStream
extends InputStream {
    private InputStream in;

    public JdkHttpInputStream(JdkHttpResponse response) {
        this.init(response);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private void init(JdkHttpResponse response) {
        block3: {
            try {
                this.in = response.status < 400 ? response.httpConnection.getInputStream() : response.httpConnection.getErrorStream();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block3;
                throw new HttpException(e);
            }
        }
        if (null == this.in) {
            this.in = new ByteArrayInputStream(StrUtil.format((CharSequence)"Error request, null response with status: {}", (Object[])new Object[]{response.status}).getBytes());
            return;
        }
        this.in = GlobalCompressStreamRegister.INSTANCE.wrapStream(this.in, response.contentEncoding());
    }
}

