/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.meta;

import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.HeaderName;

public class HttpHeaderUtil {
    public static List<String> headerList(Map<String, List<String>> headers, String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        CaseInsensitiveMap headersIgnoreCase = new CaseInsensitiveMap(headers);
        return (List)headersIgnoreCase.get((Object)name.trim());
    }

    public static String getFileNameFromDisposition(Map<String, List<String>> headers, String paramName) {
        paramName = (String)ObjUtil.defaultIfNull((Object)paramName, (Object)"filename");
        List<String> dispositions = HttpHeaderUtil.headerList(headers, HeaderName.CONTENT_DISPOSITION.name());
        String fileName = null;
        if (CollUtil.isNotEmpty(dispositions) && !StrUtil.endWith((CharSequence)(fileName = HttpHeaderUtil.getFileNameFromDispositions(dispositions, StrUtil.addSuffixIfNot((CharSequence)paramName, (CharSequence)"*"))), (CharSequence)"*") && StrUtil.isBlank((CharSequence)fileName)) {
            fileName = HttpHeaderUtil.getFileNameFromDispositions(dispositions, paramName);
        }
        return fileName;
    }

    private static String getFileNameFromDispositions(List<String> dispositions, String paramName) {
        String fileName = null;
        for (String disposition : dispositions) {
            fileName = ReUtil.getGroup1((String)(paramName + "=\"(.*?)\""), (CharSequence)disposition);
            if (!StrUtil.isNotBlank((CharSequence)fileName)) continue;
            break;
        }
        return fileName;
    }
}

