/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.text.StrUtil;

public interface HttpBody {
    public void write(OutputStream var1);

    public String getContentType();

    default public String getContentType(Charset charset) {
        String contentType = this.getContentType();
        if (null == contentType) {
            return null;
        }
        String charsetName = charset.name();
        if (StrUtil.endWithIgnoreCase((CharSequence)contentType, (CharSequence)charsetName) || StrUtil.containsIgnoreCase((CharSequence)contentType, (CharSequence)"boundary=")) {
            return contentType;
        }
        if (StrUtil.containsIgnoreCase((CharSequence)contentType, (CharSequence)";charset=")) {
            contentType = StrUtil.subBefore((CharSequence)contentType, (CharSequence)";charset=", (boolean)true);
        }
        return contentType + ";charset=" + charset.name();
    }

    default public void writeClose(OutputStream out) {
        try {
            this.write(out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
    }

    default public InputStream getStream() {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.writeClose((OutputStream)out);
        return IoUtil.toStream((FastByteArrayOutputStream)out);
    }

    default public byte[] getBytes() {
        InputStream bodyStream = this.getStream();
        if (bodyStream == null) {
            return null;
        }
        return IoUtil.readBytes((InputStream)bodyStream);
    }
}

