/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.client.body.FormBody;
import org.dromara.hutool.http.client.body.MultipartOutputStream;
import org.dromara.hutool.http.meta.ContentType;

public class MultipartBody
extends FormBody<MultipartBody> {
    private static final String CONTENT_TYPE_MULTIPART_PREFIX = ContentType.MULTIPART.getValue() + "; boundary=";
    private final String boundary;

    public static MultipartBody of(Map<String, Object> form, Charset charset) {
        return MultipartBody.of(form, charset, HttpGlobalConfig.getBoundary());
    }

    public static MultipartBody of(Map<String, Object> form, Charset charset, String boundary) {
        return new MultipartBody(form, charset, boundary);
    }

    public MultipartBody(Map<String, Object> form, Charset charset, String boundary) {
        super(form, charset);
        this.boundary = boundary;
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE_MULTIPART_PREFIX + this.boundary;
    }

    @Override
    public String getContentType(Charset charset) {
        return this.getContentType();
    }

    @Override
    public void write(OutputStream out) {
        MultipartOutputStream stream = new MultipartOutputStream(out, this.charset, this.boundary);
        if (MapUtil.isNotEmpty((Map)this.form)) {
            this.form.forEach(stream::write);
        }
        stream.finish();
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(out);
        return IoUtil.toStr((ByteArrayOutputStream)out, (Charset)this.charset);
    }
}

