/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.cookie;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.net.url.UrlUtil;
import org.dromara.hutool.http.client.cookie.ThreadLocalCookieStore;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;

public class GlobalCookieManager {
    private static CookieManager cookieManager = new CookieManager(new ThreadLocalCookieStore(), CookiePolicy.ACCEPT_ALL);

    public static void closeCookie() {
        GlobalCookieManager.setCookieManager(null);
    }

    public static void setCookieManager(CookieManager customCookieManager) {
        cookieManager = customCookieManager;
    }

    public static CookieManager getCookieManager() {
        return cookieManager;
    }

    public static List<HttpCookie> getCookies(JdkHttpConnection conn) {
        return cookieManager.getCookieStore().get(GlobalCookieManager.getURI(conn));
    }

    public static void add(JdkHttpConnection conn) {
        Map<String, List<String>> cookieHeader;
        if (null == cookieManager) {
            return;
        }
        try {
            cookieHeader = cookieManager.get(GlobalCookieManager.getURI(conn), new HashMap<String, List<String>>(0));
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        conn.header(cookieHeader, false);
    }

    public static void store(JdkHttpConnection conn) {
        GlobalCookieManager.store(conn, conn.headers());
    }

    public static void store(JdkHttpConnection conn, Map<String, List<String>> responseHeaders) {
        if (null == cookieManager || MapUtil.isEmpty(responseHeaders)) {
            return;
        }
        try {
            cookieManager.put(GlobalCookieManager.getURI(conn), responseHeaders);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    private static URI getURI(JdkHttpConnection conn) {
        return UrlUtil.toURI((URL)conn.getUrl());
    }
}

