/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.okhttp.BasicProxyAuthenticator;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpRequestBody;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpResponse;
import org.dromara.hutool.http.proxy.HttpProxy;
import org.dromara.hutool.http.ssl.SSLInfo;

public class OkHttpEngine
implements ClientEngine {
    private ClientConfig config;
    private OkHttpClient client;

    public OkHttpEngine() {
        Assert.notNull(OkHttpClient.class);
    }

    @Override
    public OkHttpEngine init(ClientConfig config) {
        this.config = config;
        this.client = null;
        return this;
    }

    @Override
    public Response send(Request message) {
        okhttp3.Response response;
        this.initEngine();
        try {
            response = this.client.newCall(OkHttpEngine.buildRequest(message)).execute();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return new OkHttpResponse(response, message.charset());
    }

    @Override
    public Object getRawEngine() {
        return this.client;
    }

    @Override
    public void close() {
    }

    private void initEngine() {
        SSLInfo sslInfo;
        int readTimeout;
        if (null != this.client) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ClientConfig conf = (ClientConfig)ObjUtil.defaultIfNull((Object)this.config, ClientConfig::of);
        int connectionTimeout = conf.getConnectionTimeout();
        if (connectionTimeout > 0) {
            builder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = conf.getReadTimeout()) > 0) {
            builder.readTimeout((long)conf.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)conf.getReadTimeout(), TimeUnit.MILLISECONDS);
        }
        if (null != (sslInfo = conf.getSslInfo())) {
            SSLSocketFactory socketFactory = sslInfo.getSocketFactory();
            X509TrustManager trustManager = sslInfo.getTrustManager();
            if (null != socketFactory && null != trustManager) {
                builder.sslSocketFactory(socketFactory, trustManager);
            }
        }
        OkHttpEngine.setProxy(builder, conf);
        builder.followRedirects(false);
        this.client = builder.build();
    }

    private static okhttp3.Request buildRequest(Request message) {
        Request.Builder builder = new Request.Builder().url(message.handledUrl().toURL());
        String method = message.method().name();
        HttpBody body = message.handledBody();
        if (null != body) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(body));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }

    private static void setProxy(OkHttpClient.Builder builder, ClientConfig config) {
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            builder.proxy((Proxy)proxy);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                builder.proxyAuthenticator((Authenticator)new BasicProxyAuthenticator(auth));
            }
        }
    }
}

