/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.meta;

import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.http.meta.ContentType;

public class ContentTypeUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset\\s*=\\s*([a-z0-9-]*)", 2);

    public static Charset getCharset(String contentType) {
        return CharsetUtil.parse((String)ContentTypeUtil.getCharsetName(contentType), null);
    }

    public static String getCharsetName(String contentType) {
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return null;
        }
        return ReUtil.get((Pattern)CHARSET_PATTERN, (CharSequence)contentType, (int)1);
    }

    public static String getContentTypeByRequestBody(String body) {
        ContentType contentType = ContentType.get(body);
        return null == contentType ? null : contentType.toString();
    }
}

