/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.webservice;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBodyElement;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.core.xml.XmlUtil;
import org.dromara.hutool.http.client.HeaderOperation;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.http.webservice.SoapProtocol;
import org.dromara.hutool.http.webservice.SoapRuntimeException;
import org.dromara.hutool.http.webservice.SoapUtil;

public class SoapClient
implements HeaderOperation<SoapClient> {
    private static final String CONTENT_TYPE_SOAP11_TEXT_XML = "text/xml;charset=";
    private static final String CONTENT_TYPE_SOAP12_SOAP_XML = "application/soap+xml;charset=";
    private String url;
    private Charset charset = CharsetUtil.UTF_8;
    private MessageFactory factory;
    private SOAPMessage message;
    private SOAPBodyElement methodEle;
    private final String namespaceURI;
    private final SoapProtocol protocol;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public static SoapClient of(String url) {
        return new SoapClient(url);
    }

    public static SoapClient of(String url, SoapProtocol protocol) {
        return new SoapClient(url, protocol);
    }

    public static SoapClient of(String url, SoapProtocol protocol, String namespaceURI) {
        return new SoapClient(url, protocol, namespaceURI);
    }

    public SoapClient(String url) {
        this(url, SoapProtocol.SOAP_1_1);
    }

    public SoapClient(String url, SoapProtocol protocol) {
        this(url, protocol, null);
    }

    public SoapClient(String url, SoapProtocol protocol, String namespaceURI) {
        this.url = url;
        this.namespaceURI = namespaceURI;
        this.protocol = protocol;
        this.init(protocol);
    }

    public SoapClient init(SoapProtocol protocol) {
        try {
            this.factory = MessageFactory.newInstance((String)protocol.getValue());
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public SoapClient reset() {
        try {
            this.message = this.factory.createMessage();
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        this.methodEle = null;
        return this;
    }

    public SoapClient charset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
            try {
                this.message.setProperty("jakarta.xml.soap.character-set-encoding", (Object)charset.name());
                this.message.setProperty("jakarta.xml.soap.write-xml-declaration", (Object)"true");
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
        }
        return this;
    }

    public SoapClient setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public SoapClient header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollUtil.isEmpty(values)) {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(name.trim(), valueList);
            } else {
                values.add(value.trim());
            }
        }
        return this;
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public SoapClient clearHeaders() {
        this.headers.clear();
        return this;
    }

    public SOAPHeaderElement addSOAPHeader(QName name, String actorURI, String roleUri, Boolean mustUnderstand, Boolean relay) {
        SOAPHeaderElement ele = this.addSOAPHeader(name);
        try {
            if (StrUtil.isNotBlank((CharSequence)roleUri)) {
                ele.setRole(roleUri);
            }
            if (null != relay) {
                ele.setRelay(relay.booleanValue());
            }
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (StrUtil.isNotBlank((CharSequence)actorURI)) {
            ele.setActor(actorURI);
        }
        if (null != mustUnderstand) {
            ele.setMustUnderstand(mustUnderstand.booleanValue());
        }
        return ele;
    }

    public SOAPHeaderElement addSOAPHeader(String localName) {
        return this.addSOAPHeader(new QName(localName));
    }

    public SOAPHeaderElement addSOAPHeader(String localName, String value) {
        SOAPHeaderElement soapHeaderElement = this.addSOAPHeader(localName);
        soapHeaderElement.setTextContent(value);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addSOAPHeader(QName name) {
        SOAPHeaderElement ele;
        try {
            ele = this.message.getSOAPHeader().addHeaderElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return ele;
    }

    public SoapClient setMethod(Name name, Map<String, Object> params, boolean useMethodPrefix) {
        return this.setMethod(new QName(name.getURI(), name.getLocalName(), name.getPrefix()), params, useMethodPrefix);
    }

    public SoapClient setMethod(QName name, Map<String, Object> params, boolean useMethodPrefix) {
        this.setMethod(name);
        String prefix = useMethodPrefix ? name.getPrefix() : null;
        SOAPBodyElement methodEle = this.methodEle;
        for (Map.Entry entry : MapUtil.wrap(params)) {
            SoapClient.setParam((SOAPElement)methodEle, (String)entry.getKey(), entry.getValue(), prefix);
        }
        return this;
    }

    public SoapClient setMethod(String methodName) {
        return this.setMethod(methodName, (String)ObjUtil.defaultIfNull((Object)this.namespaceURI, (Object)""));
    }

    public SoapClient setMethod(String methodName, String namespaceURI) {
        List methodNameList = SplitUtil.split((CharSequence)methodName, (CharSequence)":");
        QName qName = 2 == methodNameList.size() ? new QName(namespaceURI, (String)methodNameList.get(1), (String)methodNameList.get(0)) : new QName(namespaceURI, methodName);
        return this.setMethod(qName);
    }

    public SoapClient setMethod(QName name) {
        try {
            this.methodEle = this.message.getSOAPBody().addBodyElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public SoapClient setParam(String name, Object value) {
        return this.setParam(name, value, true);
    }

    public SoapClient setParam(String name, Object value, boolean useMethodPrefix) {
        SoapClient.setParam((SOAPElement)this.methodEle, name, value, useMethodPrefix ? this.methodEle.getPrefix() : null);
        return this;
    }

    public SoapClient setParams(Map<String, Object> params) {
        return this.setParams(params, true);
    }

    public SoapClient setParams(Map<String, Object> params, boolean useMethodPrefix) {
        for (Map.Entry entry : MapUtil.wrap(params)) {
            this.setParam((String)entry.getKey(), entry.getValue(), useMethodPrefix);
        }
        return this;
    }

    public SOAPBodyElement getMethodEle() {
        return this.methodEle;
    }

    public SOAPMessage getMessage() {
        return this.message;
    }

    public String getMsgStr(boolean pretty) {
        return SoapUtil.toString(this.message, pretty, this.charset);
    }

    public SoapClient write(OutputStream out) {
        try {
            this.message.writeTo(out);
        }
        catch (SOAPException | IOException e) {
            throw new SoapRuntimeException(e);
        }
        return this;
    }

    public SOAPMessage sendForMessage() {
        SOAPMessage sOAPMessage;
        Response res = this.sendForResponse();
        MimeHeaders headers = new MimeHeaders();
        for (Map.Entry<String, List<String>> entry : res.headers().entrySet()) {
            if (!StrUtil.isNotEmpty((CharSequence)entry.getKey())) continue;
            headers.setHeader(entry.getKey(), (String)CollUtil.get((Collection)entry.getValue(), (int)0));
        }
        try {
            sOAPMessage = this.factory.createMessage(headers, res.bodyStream());
        }
        catch (SOAPException | IOException e) {
            try {
                throw new SoapRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{res});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{res});
        return sOAPMessage;
    }

    public String send() {
        return this.send(false);
    }

    public String send(boolean pretty) {
        String body = this.sendForResponse().bodyStr();
        return pretty ? XmlUtil.format((String)body) : body;
    }

    public Response sendForResponse() {
        Request request = ((Request)((Request)Request.of(this.url).method(Method.POST).setMaxRedirectCount(2).contentType(this.getXmlContentType())).header(this.headers, false)).body(this.getMsgStr(false));
        return request.send();
    }

    private String getXmlContentType() {
        switch (this.protocol) {
            case SOAP_1_1: {
                return CONTENT_TYPE_SOAP11_TEXT_XML.concat(this.charset.toString());
            }
            case SOAP_1_2: {
                return CONTENT_TYPE_SOAP12_SOAP_XML.concat(this.charset.toString());
            }
        }
        throw new SoapRuntimeException("Unsupported protocol: {}", new Object[]{this.protocol});
    }

    private static SOAPElement setParam(SOAPElement ele, String name, Object value, String prefix) {
        SOAPElement childEle;
        try {
            childEle = StrUtil.isNotBlank((CharSequence)prefix) ? ele.addChildElement(name, prefix) : ele.addChildElement(name);
        }
        catch (SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        if (null != value) {
            if (value instanceof SOAPElement) {
                try {
                    ele.addChildElement((SOAPElement)value);
                }
                catch (SOAPException e) {
                    throw new SoapRuntimeException(e);
                }
            } else if (value instanceof Map) {
                Iterator iterator = ((Map)value).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    SoapClient.setParam(childEle, StrUtil.toStringOrNull(entry.getKey()), entry.getValue(), prefix);
                }
            } else {
                childEle.setValue(value.toString());
            }
        }
        return childEle;
    }
}

