/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import org.dromara.hutool.core.io.stream.EmptyInputStream;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.GlobalCompressStreamRegister;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.meta.HeaderName;

public class OkHttpResponse
implements Response {
    private final okhttp3.Response rawRes;
    private final Charset requestCharset;

    public OkHttpResponse(okhttp3.Response rawRes, Charset requestCharset) {
        this.rawRes = rawRes;
        this.requestCharset = requestCharset;
    }

    @Override
    public int getStatus() {
        return this.rawRes.code();
    }

    @Override
    public String header(String name) {
        return this.rawRes.header(name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.rawRes.headers().toMultimap();
    }

    @Override
    public Charset charset() {
        return (Charset)ObjUtil.defaultIfNull((Object)Response.super.charset(), (Object)this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        ResponseBody body = this.rawRes.body();
        if (null == body) {
            return EmptyInputStream.INSTANCE;
        }
        return GlobalCompressStreamRegister.INSTANCE.wrapStream(body.byteStream(), this.rawRes.header(HeaderName.CONTENT_ENCODING.getValue()));
    }

    @Override
    public void close() {
        if (null != this.rawRes) {
            this.rawRes.close();
        }
    }

    public String toString() {
        return HttpUtil.toString(this);
    }
}

