/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.net.url.UrlQuery;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.http.GlobalHeaders;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.HeaderOperation;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.FormBody;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.body.MultipartBody;
import org.dromara.hutool.http.client.body.StringBody;
import org.dromara.hutool.http.client.body.UrlEncodedFormBody;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.ClientEngineFactory;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.Method;

public class Request
implements HeaderOperation<Request> {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    private Method method;
    private UrlBuilder url;
    private Charset charset = DEFAULT_CHARSET;
    private final ListValueMap<String, String> headers;
    private HttpBody body;
    private int maxRedirectCount;
    private boolean isRest;

    public static Request ofWithoutEncode(String url) {
        return Request.of(url, null);
    }

    public static Request of(String url) {
        return Request.of(url, DEFAULT_CHARSET);
    }

    public static Request of(String url, Charset decodeAndEncodeCharset) {
        return Request.of(UrlBuilder.ofHttp((String)url, (Charset)decodeAndEncodeCharset));
    }

    public static Request of(UrlBuilder url) {
        return new Request().url(url);
    }

    public Request() {
        this.method = Method.GET;
        this.headers = new ListValueMap(new LinkedHashMap());
        this.maxRedirectCount = HttpGlobalConfig.getMaxRedirectCount();
        this.header(GlobalHeaders.INSTANCE.headers(), false);
    }

    public Method method() {
        return this.method;
    }

    public Request method(Method method) {
        this.method = method;
        return this;
    }

    public UrlBuilder url() {
        return this.url;
    }

    public UrlBuilder handledUrl() {
        return this.urlWithParamIfGet();
    }

    public Request url(UrlBuilder url) {
        this.url = url;
        return this;
    }

    public Request charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public Request setEncodeUrl(boolean isEncodeUrl) {
        Assert.notNull((Object)this.url, (String)"Request URL must be not null!", (Object[])new Object[0]);
        this.url.setCharset(isEncodeUrl ? this.charset : null);
        return this;
    }

    @Override
    public Map<String, ? extends Collection<String>> headers() {
        return MapUtil.view(this.headers);
    }

    @Override
    public Request header(String name, String value, boolean isOverride) {
        if (null == name) {
            return this;
        }
        if (null == value) {
            this.headers.remove((Object)name);
            return this;
        }
        if (isOverride) {
            this.headers.put((Object)name.trim(), (Object)ListUtil.of((Object[])new String[]{value}));
        } else {
            this.headers.putValue((Object)name.trim(), (Object)value);
        }
        return this;
    }

    public Request basicAuth(String username, String password) {
        return (Request)this.basicAuth(username, password, this.charset);
    }

    public HttpBody body() {
        return this.body;
    }

    public String bodyStr() {
        return StrUtil.str((byte[])this.bodyBytes(), (Charset)this.charset);
    }

    public byte[] bodyBytes() {
        return this.body == null ? null : this.body.getBytes();
    }

    public InputStream bodyStream() {
        return this.body == null ? null : this.body.getStream();
    }

    public HttpBody handledBody() {
        if (Method.GET.equals((Object)this.method) && !this.isRest) {
            return null;
        }
        return this.body();
    }

    public Request form(Map<String, Object> formMap) {
        AtomicBoolean isMultiPart = new AtomicBoolean(false);
        formMap.forEach((key, value) -> {
            if (Request.hasMultipartValue(value)) {
                isMultiPart.set(true);
            }
        });
        if (isMultiPart.get()) {
            return this.body(MultipartBody.of(formMap, this.charset()));
        }
        return this.body(new UrlEncodedFormBody(formMap, this.charset()));
    }

    public Request body(String body) {
        return this.body(new StringBody(body, this.charset()));
    }

    public Request body(HttpBody body) {
        this.body = body;
        if (StrUtil.isBlank((CharSequence)this.header(HeaderName.CONTENT_TYPE))) {
            this.header(HeaderName.CONTENT_TYPE, body.contentType(this.charset()), true);
        }
        return this;
    }

    public int maxRedirectCount() {
        return this.maxRedirectCount;
    }

    public Request setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public Request setRest(boolean isRest) {
        this.isRest = isRest;
        return this;
    }

    public Response send() {
        return this.send(ClientEngineFactory.getEngine());
    }

    public Response send(ClientEngine engine) {
        return engine.send(this);
    }

    private UrlBuilder urlWithParamIfGet() {
        HttpBody body;
        if (Method.GET.equals((Object)this.method) && !this.isRest && (body = this.body) instanceof FormBody) {
            UrlBuilder urlBuilder = UrlBuilder.of((UrlBuilder)this.url);
            UrlQuery query = urlBuilder.getQuery();
            if (null == query) {
                query = UrlQuery.of();
                urlBuilder.setQuery(query);
            }
            query.addAll(((FormBody)body).form());
            return urlBuilder;
        }
        return this.url();
    }

    public String toString() {
        return HttpUtil.toString(this);
    }

    private static boolean hasMultipartValue(Object value) {
        if (value instanceof Iterable) {
            for (Object subValue : (Iterable)value) {
                if (!Request.hasMultipartValue(subValue)) continue;
                return true;
            }
        }
        return value instanceof File || value instanceof Path || value instanceof Resource || value instanceof InputStream || value instanceof Reader;
    }
}

