/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.IOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.List;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.cookie.GlobalCookieManager;
import org.dromara.hutool.http.client.engine.AbstractClientEngine;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpResponse;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.HttpStatus;

public class JdkClientEngine
extends AbstractClientEngine {
    @Override
    public Response send(Request message) {
        return this.send(message, true);
    }

    public JdkHttpResponse send(Request message, boolean isAsync) {
        JdkHttpConnection conn = this.buildConn(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
            throw new IORuntimeException((Throwable)e);
        }
        return this.sendRedirectIfPossible(conn, message, isAsync);
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void initEngine() {
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }

    private JdkHttpConnection buildConn(Request message) {
        ClientConfig config = (ClientConfig)ObjUtil.defaultIfNull((Object)this.config, ClientConfig::of);
        JdkHttpConnection conn = (JdkHttpConnection)JdkHttpConnection.of(message.handledUrl().toURL(), (Proxy)config.getProxy()).setConnectTimeout(config.getConnectionTimeout()).setReadTimeout(config.getReadTimeout()).setMethod(message.method()).setSSLInfo(config.getSslInfo()).setInstanceFollowRedirects(false).setDisableCache(config.isDisableCache()).header(message.headers(), true);
        if (!message.method().isIgnoreBody()) {
            long contentLength = message.contentLength();
            if (contentLength > 0L) {
                conn.setFixedLengthStreamingMode(contentLength);
            } else if (message.isChunked()) {
                conn.setChunkedStreamingMode(4096);
            }
        }
        if (null == message.header(HeaderName.COOKIE)) {
            GlobalCookieManager.add(conn);
        }
        return conn;
    }

    private JdkHttpResponse sendRedirectIfPossible(JdkHttpConnection conn, Request message, boolean isAsync) {
        if (message.maxRedirectCount() > 0) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (code != 200 && HttpStatus.isRedirected(code)) {
                message.url(JdkClientEngine.getLocationUrl(message.handledUrl(), conn.header(HeaderName.LOCATION)));
                if (conn.redirectCount < message.maxRedirectCount()) {
                    ++conn.redirectCount;
                    return this.send(message, isAsync);
                }
            }
        }
        return new JdkHttpResponse(conn, true, message.charset(), isAsync, message.method().isIgnoreBody());
    }

    private static UrlBuilder getLocationUrl(UrlBuilder parentUrl, String location) {
        UrlBuilder redirectUrl;
        if (!HttpUtil.isHttp(location) && !HttpUtil.isHttps(location)) {
            String query;
            List split;
            if (!location.startsWith("/")) {
                location = StrUtil.addSuffixIfNot((CharSequence)parentUrl.getPathStr(), (CharSequence)"/") + location;
            }
            if ((split = SplitUtil.split((CharSequence)location, (CharSequence)"?", (int)2, (boolean)true, (boolean)true)).size() == 2) {
                location = (String)split.get(0);
                query = (String)split.get(1);
            } else {
                query = null;
            }
            redirectUrl = UrlBuilder.of((String)parentUrl.getScheme(), (String)parentUrl.getHost(), (int)parentUrl.getPort(), (String)location, (String)query, null, (Charset)parentUrl.getCharset());
        } else {
            redirectUrl = UrlBuilder.ofHttpWithoutEncode((String)location);
        }
        return redirectUrl;
    }
}

