/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient4;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Response;

public class HttpClient4Response
extends SimpleWrapper<HttpResponse>
implements Response {
    private final HttpEntity entity;
    private final Charset requestCharset;

    public HttpClient4Response(HttpResponse rawRes, Charset requestCharset) {
        super((Object)rawRes);
        this.entity = rawRes.getEntity();
        this.requestCharset = requestCharset;
    }

    @Override
    public int getStatus() {
        return ((HttpResponse)this.raw).getStatusLine().getStatusCode();
    }

    @Override
    public String header(String name) {
        Object[] headers = ((HttpResponse)this.raw).getHeaders(name);
        if (ArrayUtil.isNotEmpty((Object[])headers)) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public Map<String, List<String>> headers() {
        Header[] headers = ((HttpResponse)this.raw).getAllHeaders();
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>(headers.length, 1.0f);
        for (Header header : headers) {
            List valueList = result.computeIfAbsent(header.getName(), k -> new ArrayList());
            valueList.add(header.getValue());
        }
        return result;
    }

    @Override
    public long contentLength() {
        return this.entity.getContentLength();
    }

    @Override
    public Charset charset() {
        return (Charset)ObjUtil.defaultIfNull((Object)Response.super.charset(), (Object)this.requestCharset);
    }

    @Override
    public InputStream bodyStream() {
        try {
            return this.entity.getContent();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public String bodyStr() throws HttpException {
        try {
            return EntityUtils.toString((HttpEntity)this.entity, (Charset)this.charset());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (ParseException e) {
            throw new HttpException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.raw instanceof Closeable) {
            ((Closeable)this.raw).close();
        }
    }

    public String toString() {
        return HttpUtil.toString(this);
    }
}

