/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.EmptyInputStream;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.ResponseBody;
import org.dromara.hutool.http.client.engine.jdk.JdkCookieManager;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpInputStream;
import org.dromara.hutool.http.meta.HeaderName;

public class JdkHttpResponse
implements Response,
Closeable {
    private final Charset requestCharset;
    private final JdkCookieManager cookieManager;
    private ResponseBody body;
    private Map<String, List<String>> headers;
    private final boolean ignoreEOFError;
    protected JdkHttpConnection httpConnection;
    protected int status;

    protected JdkHttpResponse(JdkHttpConnection httpConnection, JdkCookieManager cookieManager, boolean ignoreEOFError, Charset requestCharset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.cookieManager = cookieManager;
        this.ignoreEOFError = ignoreEOFError;
        this.requestCharset = requestCharset;
        this.init(isAsync, isIgnoreBody);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String header(String name) {
        return HttpUtil.header(this.headers, name);
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    @Override
    public Charset charset() {
        return (Charset)ObjUtil.defaultIfNull((Object)Response.super.charset(), (Object)this.requestCharset);
    }

    public JdkHttpResponse sync() {
        if (null != this.body) {
            this.body.sync();
        }
        this.close();
        return this;
    }

    public List<HttpCookie> getCookies() {
        if (this.cookieManager.isEnable()) {
            return this.cookieManager.getCookies(this.httpConnection);
        }
        return HttpCookie.parse(this.header(HeaderName.SET_COOKIE));
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (null != cookie) {
            for (HttpCookie httpCookie : cookie) {
                if (!httpCookie.getName().equals(name)) continue;
                return httpCookie;
            }
        }
        return null;
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = this.getCookie(name);
        return null == cookie ? null : cookie.getValue();
    }

    @Override
    public InputStream bodyStream() {
        return null == this.body ? EmptyInputStream.INSTANCE : this.body.getStream();
    }

    @Override
    public ResponseBody body() {
        return this.body;
    }

    @Override
    public byte[] bodyBytes() {
        this.sync();
        return this.body().getBytes();
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.body});
        this.httpConnection.closeQuietly();
    }

    public String toString() {
        return HttpUtil.toString(this);
    }

    private void init(boolean isAsync, boolean isIgnoreBody) throws HttpException {
        block6: {
            try {
                this.status = this.httpConnection.getCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block6;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null != this.cookieManager) {
            this.cookieManager.saveFromResponse(this.httpConnection, this.headers);
        }
        if (!isIgnoreBody) {
            this.body = new ResponseBody(this, new JdkHttpInputStream(this), isAsync, this.ignoreEOFError);
        }
    }
}

