/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.meta;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.net.url.UrlDecoder;
import org.dromara.hutool.core.net.url.UrlEncoder;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.HeaderName;

public class HttpHeaderUtil {
    public static List<String> headerList(Map<String, List<String>> headers, String name) {
        if (StrUtil.isBlank((CharSequence)name)) {
            return null;
        }
        CaseInsensitiveMap headersIgnoreCase = new CaseInsensitiveMap(headers);
        return (List)headersIgnoreCase.get((Object)name.trim());
    }

    public static String createAttachmentDisposition(String fileName, Charset charset) {
        String encodeText = UrlEncoder.encodeAll((String)fileName, (Charset)charset);
        return StrUtil.format((CharSequence)"attachment;filename=\"{}\";filename*={}''{}", (Object[])new Object[]{encodeText, charset.name(), encodeText});
    }

    public static String getFileNameFromDisposition(Map<String, List<String>> headers, String paramName) {
        paramName = (String)ObjUtil.defaultIfNull((Object)paramName, (Object)"filename");
        List<String> dispositions = HttpHeaderUtil.headerList(headers, HeaderName.CONTENT_DISPOSITION.getValue());
        String fileName = null;
        if (CollUtil.isNotEmpty(dispositions) && !StrUtil.endWith((CharSequence)(fileName = HttpHeaderUtil.getFileNameFromDispositions(dispositions, StrUtil.addSuffixIfNot((CharSequence)paramName, (CharSequence)"*"))), (CharSequence)"*") && StrUtil.isBlank((CharSequence)fileName)) {
            fileName = HttpHeaderUtil.getFileNameFromDispositions(dispositions, paramName);
        }
        return fileName;
    }

    private static String getFileNameFromDispositions(List<String> dispositions, String paramName) {
        paramName = StrUtil.replace((CharSequence)paramName, (CharSequence)"*", (CharSequence)"\\*");
        String fileName = null;
        for (String disposition : dispositions) {
            fileName = ReUtil.getGroup1((String)(paramName + "\\s*=\\s*([^;]+)"), (CharSequence)disposition);
            if (!StrUtil.isNotBlank((CharSequence)fileName)) continue;
            break;
        }
        return HttpHeaderUtil.getRfc5987Value(fileName);
    }

    private static String getRfc5987Value(String value) {
        return ExtendedValue.of(value).getDecodeValue();
    }

    public static class ExtendedValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Charset charset;
        private String language;
        private final String value;

        public static ExtendedValue of(String value) {
            return new ExtendedValue(value);
        }

        public ExtendedValue(String value) {
            List split = SplitUtil.split((CharSequence)value, (CharSequence)"'");
            if (3 == split.size()) {
                this.charset = CharsetUtil.charset((String)((String)split.get(0)));
                this.language = (String)split.get(1);
                this.value = (String)split.get(2);
            } else {
                this.value = StrUtil.unWrap((CharSequence)value, (char)'\"');
            }
        }

        public Charset getCharset() {
            return this.charset;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getValue() {
            return this.value;
        }

        public String getDecodeValue() {
            return UrlDecoder.decodeForPath((String)this.value, (Charset)this.charset);
        }
    }
}

