/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.server.ServerConfig;
import org.dromara.hutool.http.server.engine.ServerEngine;
import org.dromara.hutool.log.LogUtil;

public class ServerEngineFactory {
    public static ServerEngine getEngine() {
        return (ServerEngine)Singleton.get((String)ServerEngine.class.getName(), ServerEngineFactory::createEngine);
    }

    public static ServerEngine createEngine(ServerConfig config) {
        return ServerEngineFactory.createEngine().init(config);
    }

    public static ServerEngine createEngine(String engineName) throws HttpException {
        if (!StrUtil.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader list = SpiUtil.loadList(ServerEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (ServerEngine)list.getService(serviceName);
        }
        throw new HttpException("No such engine named: " + engineName);
    }

    public static ServerEngine createEngine() {
        ServerEngine engine = (ServerEngine)SpiUtil.loadFirstAvailable(ServerEngine.class);
        LogUtil.debug((String)"Use [{}] Http Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }
}

