/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.net.HttpCookie;
import java.time.Instant;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.http.client.cookie.CookieSpi;

public class JdkCookie
extends SimpleWrapper<HttpCookie>
implements CookieSpi {
    public JdkCookie(HttpCookie httpCookie) {
        super((Object)httpCookie);
    }

    @Override
    public String getName() {
        return ((HttpCookie)this.raw).getName();
    }

    @Override
    public String getValue() {
        return ((HttpCookie)this.raw).getValue();
    }

    @Override
    public boolean isSecure() {
        return ((HttpCookie)this.raw).getSecure();
    }

    @Override
    public boolean isHttpOnly() {
        return ((HttpCookie)this.raw).isHttpOnly();
    }

    @Override
    public boolean isHostOnly() {
        return false;
    }

    @Override
    public String getDomain() {
        return ((HttpCookie)this.raw).getDomain();
    }

    @Override
    public String getPath() {
        return ((HttpCookie)this.raw).getPath();
    }

    @Override
    public boolean isExpired() {
        return ((HttpCookie)this.raw).hasExpired();
    }

    @Override
    public boolean isExpired(Instant now) {
        long maxAge = ((HttpCookie)this.raw).getMaxAge();
        if (maxAge == 0L) {
            return true;
        }
        if (maxAge < 0L) {
            return false;
        }
        long creationTime = (Long)MethodUtil.invoke((Object)this.raw, (String)"getCreationTime", (Object[])new Object[0]);
        long deltaSecond = (now.toEpochMilli() - creationTime) / 1000L;
        return deltaSecond > maxAge;
    }

    @Override
    public String getAttribute(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }
}

