/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.net.url.UrlQueryUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.ContentTypeUtil;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.http.multipart.MultipartFormData;
import org.dromara.hutool.http.multipart.UploadSetting;
import org.dromara.hutool.http.useragent.UserAgent;
import org.dromara.hutool.http.useragent.UserAgentUtil;

public interface ServerRequest {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    public String getMethod();

    default public boolean isGetMethod() {
        return Method.GET.name().equalsIgnoreCase(this.getMethod());
    }

    default public boolean isPostMethod() {
        return Method.POST.name().equalsIgnoreCase(this.getMethod());
    }

    public String getPath();

    public String getQuery();

    public String getHeader(String var1);

    default public String getHeader(HeaderName headerNameKey) {
        return this.getHeader(headerNameKey.toString());
    }

    default public String getHeader(String headerKey, Charset charset) {
        String header = this.getHeader(headerKey);
        if (null != header) {
            return CharsetUtil.convert((String)header, (Charset)CharsetUtil.ISO_8859_1, (Charset)charset);
        }
        return null;
    }

    default public String getContentType() {
        return this.getHeader(HeaderName.CONTENT_TYPE);
    }

    default public long getContentLength() {
        String contentLength = this.getHeader(HeaderName.CONTENT_LENGTH);
        return StrUtil.isEmpty((CharSequence)contentLength) ? -1L : Long.parseLong(contentLength);
    }

    default public Charset getCharset() {
        String contentType = this.getContentType();
        return (Charset)ObjUtil.defaultIfNull((Object)ContentTypeUtil.getCharset(contentType), (Object)DEFAULT_CHARSET);
    }

    default public String getUserAgentStr() {
        return this.getHeader(HeaderName.USER_AGENT);
    }

    default public UserAgent getUserAgent() {
        return UserAgentUtil.parse(this.getUserAgentStr());
    }

    default public String getCookiesStr() {
        return this.getHeader(HeaderName.COOKIE);
    }

    default public boolean isMultipart() {
        if (!this.isPostMethod()) {
            return false;
        }
        String contentType = this.getContentType();
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public InputStream getBodyStream();

    default public String getBody() {
        return this.getBody(this.getCharset());
    }

    default public String getBody(Charset charset) {
        return StrUtil.str((byte[])this.getBodyBytes(), (Charset)charset);
    }

    default public byte[] getBodyBytes() {
        return IoUtil.readBytes((InputStream)this.getBodyStream(), (boolean)true);
    }

    default public MultipartFormData getMultipart() throws IORuntimeException {
        return this.parseMultipart(new UploadSetting());
    }

    default public MultipartFormData parseMultipart(UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(this.getBodyStream(), this.getCharset());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return formData;
    }

    default public String getParam(String name) {
        return (String)this.getParams().getValue((Object)name, 0);
    }

    default public Collection<String> getParams(String name) {
        return (Collection)this.getParams().get((Object)name);
    }

    default public ListValueMap<String, String> getParams() {
        ListValueMap params = new ListValueMap();
        Charset charset = this.getCharset();
        String query = this.getQuery();
        if (StrUtil.isNotBlank((CharSequence)query)) {
            params.putAll(UrlQueryUtil.decodeQueryList((String)query, (Charset)charset));
        }
        if (this.isMultipart()) {
            params.putAll(this.getMultipart().getParamListMap());
        } else {
            String body = this.getBody();
            if (StrUtil.isNotBlank((CharSequence)body)) {
                params.putAll(UrlQueryUtil.decodeQueryList((String)body, (Charset)charset));
            }
        }
        return params;
    }
}

