/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.body.ResponseBody;
import org.dromara.hutool.http.meta.ContentTypeUtil;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.HttpHeaderUtil;

public interface Response
extends Closeable {
    public int getStatus();

    public String header(String var1);

    public Map<String, List<String>> headers();

    default public Charset charset() {
        return ContentTypeUtil.getCharset(this.header(HeaderName.CONTENT_TYPE));
    }

    public InputStream bodyStream();

    public Response sync();

    public ResponseBody body();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public String bodyStr() throws HttpException {
        try (ResponseBody body = this.body();){
            String string = body.getString();
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public byte[] bodyBytes() {
        try (ResponseBody body = this.body();){
            byte[] byArray = null == body ? null : body.getBytes();
            return byArray;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    default public boolean isOk() {
        int status = this.getStatus();
        return status >= 200 && status < 300;
    }

    default public String header(HeaderName name) {
        if (null == name) {
            return null;
        }
        return this.header(name.toString());
    }

    default public List<String> headerList(String name) {
        return HttpHeaderUtil.headerList(this.headers(), name);
    }

    default public String contentEncoding() {
        return this.header(HeaderName.CONTENT_ENCODING);
    }

    default public long contentLength() {
        long contentLength = ConvertUtil.toLong((Object)this.header(HeaderName.CONTENT_LENGTH), (Long)-1L);
        if (contentLength > 0L && (this.isChunked() || StrUtil.isNotBlank((CharSequence)this.contentEncoding()))) {
            contentLength = -1L;
        }
        return contentLength;
    }

    default public boolean isChunked() {
        return "Chunked".equalsIgnoreCase(this.header(HeaderName.TRANSFER_ENCODING));
    }

    default public String getCookieStr() {
        return this.header(HeaderName.SET_COOKIE);
    }

    default public String getFileNameFromDisposition(String paramName) {
        return HttpHeaderUtil.getFileNameFromDisposition(this.headers(), paramName);
    }

    default public void then(Consumer<Response> consumer) {
        consumer.accept(this);
    }
}

