/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.StreamProgress;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.stream.SyncInputStream;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.html.HtmlUtil;
import org.dromara.hutool.http.meta.HeaderName;

public class ResponseBody
implements HttpBody,
Closeable {
    private final Response response;
    private final SyncInputStream bodyStream;

    public ResponseBody(Response response, InputStream in) {
        this(response, in, true, true);
    }

    public ResponseBody(Response response, InputStream in, boolean isAsync, boolean isIgnoreEOFError) {
        this.response = response;
        this.bodyStream = new SyncInputStream(in, response.contentLength(), isAsync, isIgnoreEOFError);
    }

    @Override
    public String contentType() {
        return this.response.header(HeaderName.CONTENT_TYPE);
    }

    @Override
    public long contentLength() {
        return this.response.contentLength();
    }

    @Override
    public InputStream getStream() {
        return this.bodyStream;
    }

    @Override
    public void write(OutputStream out) {
        this.write(out, false, null);
    }

    public ResponseBody sync() {
        this.bodyStream.sync();
        return this;
    }

    @Override
    public byte[] getBytes() {
        this.sync();
        return this.bodyStream.readBytes();
    }

    public String getString() {
        return HtmlUtil.getString(this.getBytes(), this.response.charset(), HttpGlobalConfig.isGetCharsetFromContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        long l;
        block3: {
            Assert.notNull((Object)out, (String)"[out] must be not null!", (Object[])new Object[0]);
            try {
                l = this.bodyStream.copyTo(out, streamProgress);
                if (!isCloseOut) break block3;
            }
            catch (Throwable throwable) {
                if (isCloseOut) {
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                }
                throw throwable;
            }
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        }
        return l;
    }

    public File write(String targetFileOrDir) {
        return this.write(FileUtil.file((String)targetFileOrDir));
    }

    public File write(File targetFileOrDir) {
        return this.write(targetFileOrDir, null);
    }

    public File write(File targetFileOrDir, StreamProgress streamProgress) {
        return this.write(targetFileOrDir, null, streamProgress);
    }

    public File write(File targetFileOrDir, String tempFileSuffix, StreamProgress streamProgress) {
        Assert.notNull((Object)targetFileOrDir, (String)"[targetFileOrDir] must be not null!", (Object[])new Object[0]);
        File outFile = this.getTargetFile(targetFileOrDir, null);
        String fileName = outFile.getName();
        outFile = new File(outFile.getParentFile(), FileNameUtil.addTempSuffix((String)fileName, (String)tempFileSuffix));
        try {
            outFile = this.writeDirect(outFile, null, streamProgress);
            return FileUtil.rename((File)outFile, (String)fileName, (boolean)true);
        }
        catch (Throwable e) {
            FileUtil.del((File)outFile);
            throw new HttpException(e);
        }
    }

    public File writeDirect(File targetFileOrDir, String customParamName, StreamProgress streamProgress) {
        Assert.notNull((Object)targetFileOrDir, (String)"[targetFileOrDir] must be not null!", (Object[])new Object[0]);
        File outFile = this.getTargetFile(targetFileOrDir, customParamName);
        this.write(FileUtil.getOutputStream((File)outFile, (OpenOption[])new OpenOption[0]), true, streamProgress);
        return outFile;
    }

    @Override
    public void close() throws IOException {
        this.bodyStream.close();
    }

    public String toString() {
        return this.getString();
    }

    private File getTargetFile(File targetFileOrDir, String customParamName) {
        if (!targetFileOrDir.isDirectory()) {
            return targetFileOrDir;
        }
        String fileName = this.response.getFileNameFromDisposition(customParamName);
        if (StrUtil.isBlank((CharSequence)fileName)) {
            throw new HttpException("Can`t get file name from [Content-Disposition]!");
        }
        return FileUtil.file((File)targetFileOrDir, (String)fileName);
    }
}

