/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.ServiceLoader;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.log.LogUtil;

public class ClientEngineFactory {
    public static ClientEngine getEngine() {
        return (ClientEngine)Singleton.get((String)ClientEngine.class.getName(), ClientEngineFactory::createEngine);
    }

    public static ClientEngine createEngine(ClientConfig config) {
        return ClientEngineFactory.createEngine().init(config);
    }

    public static ClientEngine createEngine(String engineName) throws HttpException {
        if (!StrUtil.endWithIgnoreCase((CharSequence)engineName, (CharSequence)"Engine")) {
            engineName = engineName + "Engine";
        }
        ServiceLoader list = SpiUtil.loadList(ClientEngine.class);
        for (String serviceName : list.getServiceNames()) {
            if (!StrUtil.endWithIgnoreCase((CharSequence)serviceName, (CharSequence)engineName)) continue;
            return (ClientEngine)list.getService(serviceName);
        }
        throw new HttpException("No such engine named: " + engineName);
    }

    public static ClientEngine createEngine() {
        ClientEngine engine = (ClientEngine)SpiUtil.loadFirstAvailable(ClientEngine.class);
        LogUtil.debug((String)"Use [{}] Http Engine As Default.", (Object[])new Object[]{StrUtil.removeSuffix((CharSequence)engine.getClass().getSimpleName(), (CharSequence)"Engine")});
        return engine;
    }
}

