/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.sun;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.http.meta.ContentType;
import org.dromara.hutool.http.server.engine.sun.SunServerExchangeBase;
import org.dromara.hutool.http.server.handler.ServerResponse;

public class SunServerResponse
extends SunServerExchangeBase
implements ServerResponse {
    private Charset charset;
    private boolean isSendCode;

    public SunServerResponse(HttpExchange httpExchange) {
        super(httpExchange);
    }

    @Override
    public SunServerResponse setStatus(int statusCode) {
        return this.send(statusCode, 0L);
    }

    public SunServerResponse sendOk() {
        return this.setStatus(200);
    }

    public SunServerResponse sendOk(int bodyLength) {
        return this.send(200, bodyLength);
    }

    public SunServerResponse send404(String content) {
        return this.sendError(404, content);
    }

    public SunServerResponse sendError(int errorCode, String content) {
        this.setStatus(errorCode);
        this.setContentType(ContentType.TEXT_HTML.toString());
        this.write(content);
        return this;
    }

    public SunServerResponse send(int httpStatusCode, long bodyLength) {
        if (this.isSendCode) {
            throw new IORuntimeException("Http status code has been send!");
        }
        try {
            this.httpExchange.sendResponseHeaders(httpStatusCode, bodyLength);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        this.isSendCode = true;
        return this;
    }

    @Override
    public SunServerResponse setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    public Headers getHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    @Override
    public SunServerResponse addHeader(String header, String value) {
        this.getHeaders().add(header, value);
        return this;
    }

    @Override
    public SunServerResponse setHeader(String header, String value) {
        this.getHeaders().set(header, value);
        return this;
    }

    @Override
    public SunServerResponse setHeader(String header, List<String> value) {
        this.getHeaders().put(header, value);
        return this;
    }

    public SunServerResponse setHeaders(Map<String, List<String>> headers) {
        this.getHeaders().putAll((Map<? extends String, ? extends List<String>>)headers);
        return this;
    }

    public SunServerResponse setAttr(String name, Object value) {
        this.httpExchange.setAttribute(name, value);
        return this;
    }

    @Override
    public OutputStream getOutputStream() {
        if (!this.isSendCode) {
            this.sendOk();
        }
        return this.httpExchange.getResponseBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SunServerResponse write(InputStream in, int length) {
        if (!this.isSendCode) {
            this.sendOk(Math.max(0, length));
        }
        OutputStream out = null;
        try {
            out = this.httpExchange.getResponseBody();
            IoUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return this;
    }
}

