/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.handler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.http.server.handler.HttpHandler;

public class PathTrie {
    private final Node root = new Node();

    public void add(String path, HttpHandler handler) {
        Node node = this.root;
        List parts = SplitUtil.splitTrim((CharSequence)path, (CharSequence)"/");
        for (String part : parts) {
            node = node.getOrCreateChildren(part);
        }
        node.isEndOfPath = true;
        node.handler = handler;
    }

    public HttpHandler match(String path) {
        String part;
        Node matchedNode = null;
        Node node = this.root;
        List parts = SplitUtil.splitTrim((CharSequence)path, (CharSequence)"/");
        Iterator iterator = parts.iterator();
        while (iterator.hasNext() && (node = node.getChildren(part = (String)iterator.next())) != null) {
            if (!node.isEndOfPath) continue;
            matchedNode = node;
        }
        return null == matchedNode ? null : matchedNode.handler;
    }

    static class Node {
        Map<String, Node> children;
        boolean isEndOfPath = false;
        HttpHandler handler = null;

        public Node getChildren(String part) {
            return null == this.children ? null : this.children.get(part);
        }

        public Node getOrCreateChildren(String part) {
            if (null == this.children) {
                this.children = new HashMap<String, Node>();
            }
            return this.children.computeIfAbsent(part, c -> new Node());
        }
    }
}

