/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.handler;

import java.io.File;
import java.util.List;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.http.server.handler.HttpHandler;
import org.dromara.hutool.http.server.handler.ServerRequest;
import org.dromara.hutool.http.server.handler.ServerResponse;

public class RootHandler
implements HttpHandler {
    public static final String DEFAULT_INDEX_FILE_NAME = "index.html";
    private final File rootDir;
    private final List<String> indexFileNames;

    public RootHandler(String rootDir) {
        this(new File(rootDir));
    }

    public RootHandler(File rootDir) {
        this(rootDir, DEFAULT_INDEX_FILE_NAME);
    }

    public RootHandler(String rootDir, String ... indexFileNames) {
        this(new File(rootDir), indexFileNames);
    }

    public RootHandler(File rootDir, String ... indexFileNames) {
        this.rootDir = rootDir;
        this.indexFileNames = ListUtil.of((Object[])indexFileNames);
    }

    @Override
    public void handle(ServerRequest request, ServerResponse response) {
        String path = request.getPath();
        File file = FileUtil.file((File)this.rootDir, (String)path);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String indexFileName : this.indexFileNames) {
                    if (!(file = FileUtil.file((File)file, (String)indexFileName)).exists() || !file.isFile()) continue;
                    response.write(file);
                    return;
                }
            } else {
                String name = request.getParam("name");
                response.write(file, name);
                return;
            }
        }
        response.setStatus(404);
        response.write("404 Not Found !");
    }
}

