/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.handler;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.http.server.handler.HttpHandler;
import org.dromara.hutool.http.server.handler.PathTrie;
import org.dromara.hutool.http.server.handler.ServerRequest;
import org.dromara.hutool.http.server.handler.ServerResponse;

public class RouteHttpHandler
implements HttpHandler {
    private final PathTrie pathTrie = new PathTrie();
    private final HttpHandler defaultHandler;

    public static RouteHttpHandler of(HttpHandler defaultHandler) {
        return new RouteHttpHandler(defaultHandler);
    }

    public RouteHttpHandler(HttpHandler defaultHandler) {
        this.defaultHandler = (HttpHandler)Assert.notNull((Object)defaultHandler);
    }

    public RouteHttpHandler route(String path, HttpHandler handler) {
        if (null != handler) {
            this.pathTrie.add(path, handler);
        }
        return this;
    }

    @Override
    public void handle(ServerRequest request, ServerResponse response) {
        String path = request.getPath();
        HttpHandler handler = this.pathTrie.match(path);
        if (null != handler) {
            handler.handle(request, response);
        } else {
            this.defaultHandler.handle(request, response);
        }
    }
}

