/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.jdk;

import java.io.IOException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.RequestContext;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.cookie.InMemoryCookieStore;
import org.dromara.hutool.http.client.engine.AbstractClientEngine;
import org.dromara.hutool.http.client.engine.jdk.JdkCookieManager;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpConnection;
import org.dromara.hutool.http.client.engine.jdk.JdkHttpResponse;
import org.dromara.hutool.http.client.engine.jdk.JdkRequestBuilder;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.HttpStatus;
import org.dromara.hutool.http.meta.Method;

public class JdkClientEngine
extends AbstractClientEngine {
    private JdkCookieManager cookieManager;

    public JdkCookieManager getCookieManager() {
        return this.cookieManager;
    }

    @Override
    public JdkHttpResponse send(Request message) {
        this.initEngine();
        return this.doSend(new RequestContext(message));
    }

    @Override
    public Object getRawEngine() {
        return this;
    }

    @Override
    public void close() {
        this.cookieManager = null;
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void initEngine() {
        if (null != this.cookieManager) {
            return;
        }
        if (null != this.config && this.config.isUseCookieManager()) {
            this.cookieStore = new InMemoryCookieStore();
            this.cookieManager = new JdkCookieManager(this.cookieStore);
        }
    }

    private JdkHttpResponse doSend(RequestContext context) {
        Request message = context.getRequest();
        JdkHttpConnection conn = new JdkRequestBuilder(this.config, this.cookieManager).build(message);
        try {
            this.doSend(conn, message);
        }
        catch (IOException e) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
            throw new HttpException(e);
        }
        int maxRedirects = message.maxRedirects();
        if (maxRedirects > 0 && context.getRedirectCount() < maxRedirects) {
            int code;
            try {
                code = conn.getCode();
            }
            catch (IOException e) {
                conn.closeQuietly();
                throw new HttpException(e);
            }
            if (HttpStatus.isRedirected(code)) {
                if (307 != code) {
                    message.method(Method.GET);
                }
                message.locationTo(conn.header(HeaderName.LOCATION));
                context.incrementRedirectCount();
                return this.doSend(context);
            }
        }
        return new JdkHttpResponse(conn, this.cookieManager, context.getRequest());
    }

    private void doSend(JdkHttpConnection conn, Request message) throws IOException {
        HttpBody body = message.handledBody();
        if (null != body) {
            body.writeClose(conn.getOutputStream());
            return;
        }
        conn.connect();
    }
}

