/*
 * Copyright (c) 2023 looly(loolly@aliyun.com)
 * Hutool is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package org.dromara.hutool.http.useragent;

import java.io.Serializable;

/**
 * User-Agent信息对象
 *
 * @author looly
 * @since 4.2.1
 */
public class UserAgent implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 是否为移动平台
	 */
	private boolean mobile;
	/**
	 * 浏览器类型
	 */
	private Browser browser;
	/**
	 * 浏览器版本
	 */
	private String version;

	/**
	 * 平台类型
	 */
	private Platform platform;

	/**
	 * 系统类型
	 */
	private OS os;
	/**
	 * 系统版本
	 */
	private String osVersion;

	/**
	 * 引擎类型
	 */
	private BrowserEngine engine;
	/**
	 * 引擎版本
	 */
	private String engineVersion;

	/**
	 * 是否为移动平台
	 *
	 * @return 是否为移动平台
	 */
	public boolean isMobile() {
		return mobile;
	}

	/**
	 * 设置是否为移动平台
	 *
	 * @param mobile 是否为移动平台
	 */
	public void setMobile(final boolean mobile) {
		this.mobile = mobile;
	}

	/**
	 * 获取浏览器类型
	 *
	 * @return 浏览器类型
	 */
	public Browser getBrowser() {
		return browser;
	}

	/**
	 * 设置浏览器类型
	 *
	 * @param browser 浏览器类型
	 */
	public void setBrowser(final Browser browser) {
		this.browser = browser;
	}

	/**
	 * 获取平台类型
	 *
	 * @return 平台类型
	 */
	public Platform getPlatform() {
		return platform;
	}

	/**
	 * 设置平台类型
	 *
	 * @param platform 平台类型
	 */
	public void setPlatform(final Platform platform) {
		this.platform = platform;
	}

	/**
	 * 获取系统类型
	 *
	 * @return 系统类型
	 */
	public OS getOs() {
		return os;
	}

	/**
	 * 设置系统类型
	 *
	 * @param os 系统类型
	 */
	public void setOs(final OS os) {
		this.os = os;
	}

	/**
	 * 获取系统版本
	 *
	 * @return 系统版本
	 * @since 5.7.4
	 */
	public String getOsVersion() {
		return this.osVersion;
	}

	/**
	 * 设置系统版本
	 *
	 * @param osVersion 系统版本
	 * @since 5.7.4
	 */
	public void setOsVersion(final String osVersion) {
		this.osVersion = osVersion;
	}

	/**
	 * 获取引擎类型
	 *
	 * @return 引擎类型
	 */
	public BrowserEngine getEngine() {
		return engine;
	}

	/**
	 * 设置引擎类型
	 *
	 * @param engine 引擎类型
	 */
	public void setEngine(final BrowserEngine engine) {
		this.engine = engine;
	}

	/**
	 * 获取浏览器版本
	 *
	 * @return 浏览器版本
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * 设置浏览器版本
	 *
	 * @param version 浏览器版本
	 */
	public void setVersion(final String version) {
		this.version = version;
	}

	/**
	 * 获取引擎版本
	 *
	 * @return 引擎版本
	 */
	public String getEngineVersion() {
		return engineVersion;
	}

	/**
	 * 设置引擎版本
	 *
	 * @param engineVersion 引擎版本
	 */
	public void setEngineVersion(final String engineVersion) {
		this.engineVersion = engineVersion;
	}

}
