/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http;

import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.dromara.hutool.core.compress.InflaterInputStream;
import org.dromara.hutool.core.map.CaseInsensitiveMap;

public enum GlobalCompressStreamRegister {
    INSTANCE;

    private final Map<String, Class<? extends InputStream>> compressMap = new CaseInsensitiveMap();

    private GlobalCompressStreamRegister() {
        this.compressMap.put("gzip", GZIPInputStream.class);
        this.compressMap.put("deflate", InflaterInputStream.class);
    }

    public Class<? extends InputStream> get(String contentEncoding) {
        return this.compressMap.get(contentEncoding);
    }

    public synchronized void register(String contentEncoding, Class<? extends InputStream> streamClass) {
        this.compressMap.put(contentEncoding, streamClass);
    }

    public synchronized void unRegister(String contentEncoding) {
        this.compressMap.remove(contentEncoding);
    }
}

