/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient5;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.http.GlobalHeaders;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.httpclient5.HttpClient5BodyEntity;
import org.dromara.hutool.http.client.engine.httpclient5.HttpClient5Response;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.proxy.HttpProxy;
import org.dromara.hutool.http.ssl.SSLInfo;

public class HttpClient5Engine
implements ClientEngine {
    private ClientConfig config;
    private CloseableHttpClient engine;

    @Override
    public HttpClient5Engine init(ClientConfig config) {
        this.config = config;
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.engine});
        this.engine = null;
        return this;
    }

    @Override
    public Response send(Request message) {
        ClassicHttpResponse response;
        this.initEngine();
        ClassicHttpRequest request = HttpClient5Engine.buildRequest(message);
        try {
            response = this.engine.executeOpen(null, request, null);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
        return new HttpClient5Response(response, message.charset());
    }

    @Override
    public Object getRawEngine() {
        return this.engine;
    }

    @Override
    public void close() throws IOException {
        this.engine.close();
    }

    private void initEngine() {
        if (null != this.engine) {
            return;
        }
        HttpClientBuilder clientBuilder = HttpClients.custom();
        ClientConfig config = this.config;
        if (null != config) {
            clientBuilder.setConnectionManager((HttpClientConnectionManager)HttpClient5Engine.buildConnectionManager(config));
            clientBuilder.setDefaultRequestConfig(HttpClient5Engine.buildRequestConfig(config));
            if (config.isDisableCache()) {
                clientBuilder.disableAuthCaching();
            }
        }
        clientBuilder.setDefaultHeaders(HttpClient5Engine.toHeaderList(GlobalHeaders.INSTANCE.headers()));
        clientBuilder.disableRedirectHandling();
        HttpClient5Engine.setProxy(clientBuilder, config);
        this.engine = clientBuilder.build();
    }

    private static ClassicHttpRequest buildRequest(Request message) {
        UrlBuilder url = message.url();
        Assert.notNull((Object)url, (String)"Request URL must be not null!", (Object[])new Object[0]);
        URI uri = url.toURI();
        HttpUriRequestBase request = new HttpUriRequestBase(message.method().name(), uri);
        request.setHeaders(HttpClient5Engine.toHeaderList(message.headers()).toArray(new Header[0]));
        HttpBody body = message.body();
        request.setEntity((HttpEntity)new HttpClient5BodyEntity(message.header(HeaderName.CONTENT_TYPE), message.charset(), message.isChunked(), body));
        return request;
    }

    private static List<Header> toHeaderList(Map<String, ? extends Collection<String>> headersMap) {
        ArrayList<Header> result = new ArrayList<Header>();
        headersMap.forEach((k, v1) -> v1.forEach(v2 -> result.add((Header)new BasicHeader(k, v2))));
        return result;
    }

    private static PoolingHttpClientConnectionManager buildConnectionManager(ClientConfig config) {
        int connectionTimeout;
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        SSLInfo sslInfo = config.getSslInfo();
        if (null != sslInfo) {
            connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setTlsVersions(sslInfo.getProtocols()).setSslContext(sslInfo.getSslContext()).setHostnameVerifier(sslInfo.getHostnameVerifier()).build());
        }
        if ((connectionTimeout = config.getConnectionTimeout()) > 0) {
            connectionManagerBuilder.setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(connectionTimeout, TimeUnit.MILLISECONDS).setConnectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build());
        }
        return connectionManagerBuilder.build();
    }

    private static RequestConfig buildRequestConfig(ClientConfig config) {
        int readTimeout;
        int connectionTimeout = config.getConnectionTimeout();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (connectionTimeout > 0) {
            requestConfigBuilder.setConnectionRequestTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
        }
        if ((readTimeout = config.getReadTimeout()) > 0) {
            requestConfigBuilder.setResponseTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        return requestConfigBuilder.build();
    }

    private static void setProxy(HttpClientBuilder clientBuilder, ClientConfig config) {
        if (null == config) {
            return;
        }
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            HttpHost httpHost = new HttpHost(proxy.getHost(), proxy.getPort());
            clientBuilder.setProxy(httpHost);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(httpHost), (Credentials)new UsernamePasswordCredentials(auth.getUserName(), auth.getPassword()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
    }
}

