/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.HttpResource;
import org.dromara.hutool.core.io.resource.MultiResource;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.StringResource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.meta.ContentType;

public class MultipartOutputStream
extends OutputStream {
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type: {}\r\n";
    private final OutputStream out;
    private final Charset charset;
    private final String boundary;
    private boolean isFinish;

    public MultipartOutputStream(OutputStream out, Charset charset) {
        this(out, charset, HttpGlobalConfig.getBoundary());
    }

    public MultipartOutputStream(OutputStream out, Charset charset, String boundary) {
        this.out = out;
        this.charset = charset;
        this.boundary = boundary;
    }

    public MultipartOutputStream write(String formFieldName, Object value) throws IORuntimeException {
        if (value instanceof MultiResource) {
            for (Resource subResource : (MultiResource)value) {
                this.write(formFieldName, (Object)subResource);
            }
            return this;
        }
        this.beginPart();
        if (value instanceof Resource) {
            this.appendResource(formFieldName, (Resource)value);
        } else {
            this.appendResource(formFieldName, (Resource)new StringResource(Convert.toStr((Object)value), null, this.charset));
        }
        this.write("\r\n");
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void finish() throws IORuntimeException {
        if (!this.isFinish) {
            this.write(StrUtil.format((CharSequence)"--{}--\r\n", (Object[])new Object[]{this.boundary}));
            this.isFinish = true;
        }
    }

    @Override
    public void close() {
        this.finish();
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.out});
    }

    private void appendResource(String formFieldName, Resource resource) throws IORuntimeException {
        String fileName = resource.getName();
        if (null == fileName) {
            this.write(StrUtil.format((CharSequence)CONTENT_DISPOSITION_TEMPLATE, (Object[])new Object[]{formFieldName}));
        } else {
            this.write(StrUtil.format((CharSequence)CONTENT_DISPOSITION_FILE_TEMPLATE, (Object[])new Object[]{formFieldName, fileName}));
        }
        if (resource instanceof HttpResource) {
            String contentType = ((HttpResource)resource).getContentType();
            if (StrUtil.isNotBlank((CharSequence)contentType)) {
                this.write(StrUtil.format((CharSequence)CONTENT_TYPE_FILE_TEMPLATE, (Object[])new Object[]{contentType}));
            }
        } else if (StrUtil.isNotEmpty((CharSequence)fileName)) {
            this.write(StrUtil.format((CharSequence)CONTENT_TYPE_FILE_TEMPLATE, (Object[])new Object[]{FileUtil.getMimeType((String)fileName, (String)ContentType.OCTET_STREAM.getValue())}));
        }
        this.write("\r\n");
        resource.writeTo((OutputStream)this);
    }

    private void beginPart() {
        this.write("--", this.boundary, "\r\n");
    }

    private void write(Object ... objs) {
        IoUtil.write((OutputStream)this, (Charset)this.charset, (boolean)false, (Object[])objs);
    }
}

