/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.body;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;

public interface HttpBody {
    public void write(OutputStream var1);

    public String getContentType();

    default public String getContentType(Charset charset) {
        String contentType = this.getContentType();
        if (null == contentType) {
            return null;
        }
        return contentType + ";charset=" + charset.name();
    }

    default public void writeClose(OutputStream out) {
        try {
            this.write(out);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
    }

    default public InputStream getStream() {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        this.writeClose((OutputStream)out);
        return IoUtil.toStream((FastByteArrayOutputStream)out);
    }
}

