/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.LimitedInputStream;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.net.NetUtil;
import org.dromara.hutool.core.net.multipart.MultipartFormData;
import org.dromara.hutool.core.net.multipart.UploadSetting;
import org.dromara.hutool.core.net.url.UrlQueryUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.meta.ContentTypeUtil;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.http.server.HttpServerBase;
import org.dromara.hutool.http.useragent.UserAgent;
import org.dromara.hutool.http.useragent.UserAgentUtil;

public class HttpServerRequest
extends HttpServerBase {
    private Map<String, HttpCookie> cookieCache;
    private ListValueMap<String, String> paramsCache;
    private MultipartFormData multipartFormDataCache;
    private Charset charsetCache;
    private byte[] bodyCache;

    public HttpServerRequest(HttpExchange httpExchange) {
        super(httpExchange);
    }

    public String getMethod() {
        return this.httpExchange.getRequestMethod();
    }

    public boolean isGetMethod() {
        return Method.GET.name().equalsIgnoreCase(this.getMethod());
    }

    public boolean isPostMethod() {
        return Method.POST.name().equalsIgnoreCase(this.getMethod());
    }

    public URI getURI() {
        return this.httpExchange.getRequestURI();
    }

    public String getPath() {
        return this.getURI().getPath();
    }

    public String getQuery() {
        return this.getURI().getQuery();
    }

    public Headers getHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    public String getHeader(HeaderName headerNameKey) {
        return this.getHeader(headerNameKey.toString());
    }

    public String getHeader(String headerKey) {
        return this.getHeaders().getFirst(headerKey);
    }

    public String getHeader(String headerKey, Charset charset) {
        String header = this.getHeader(headerKey);
        if (null != header) {
            return CharsetUtil.convert((String)header, (Charset)CharsetUtil.ISO_8859_1, (Charset)charset);
        }
        return null;
    }

    public String getContentType() {
        return this.getHeader(HeaderName.CONTENT_TYPE);
    }

    public Charset getCharset() {
        if (null == this.charsetCache) {
            String contentType = this.getContentType();
            this.charsetCache = (Charset)ObjUtil.defaultIfNull((Object)ContentTypeUtil.getCharset(contentType), (Object)DEFAULT_CHARSET);
        }
        return this.charsetCache;
    }

    public String getUserAgentStr() {
        return this.getHeader(HeaderName.USER_AGENT);
    }

    public UserAgent getUserAgent() {
        return UserAgentUtil.parse(this.getUserAgentStr());
    }

    public String getCookiesStr() {
        return this.getHeader(HeaderName.COOKIE);
    }

    public Collection<HttpCookie> getCookies() {
        return this.getCookieMap().values();
    }

    public Map<String, HttpCookie> getCookieMap() {
        if (null == this.cookieCache) {
            this.cookieCache = MapUtil.view((Map)MapUtil.putAll((Map)new CaseInsensitiveMap(), (Iterable)NetUtil.parseCookies((String)this.getCookiesStr()), HttpCookie::getName));
        }
        return this.cookieCache;
    }

    public HttpCookie getCookie(String cookieName) {
        return this.getCookieMap().get(cookieName);
    }

    public boolean isMultipart() {
        if (!this.isPostMethod()) {
            return false;
        }
        String contentType = this.getContentType();
        if (StrUtil.isBlank((CharSequence)contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public String getBody() {
        return this.getBody(this.getCharset());
    }

    public String getBody(Charset charset) {
        return StrUtil.str((byte[])this.getBodyBytes(), (Charset)charset);
    }

    public byte[] getBodyBytes() {
        if (null == this.bodyCache) {
            this.bodyCache = IoUtil.readBytes((InputStream)this.getBodyStream(), (boolean)true);
        }
        return this.bodyCache;
    }

    public InputStream getBodyStream() {
        InputStream bodyStream = this.httpExchange.getRequestBody();
        String contentLengthStr = this.getHeader(HeaderName.CONTENT_LENGTH);
        long contentLength = 0L;
        if (StrUtil.isNotBlank((CharSequence)contentLengthStr)) {
            try {
                contentLength = Long.parseLong(contentLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (contentLength > 0L) {
            bodyStream = new LimitedInputStream(bodyStream, contentLength);
        }
        return bodyStream;
    }

    public String getParam(String name) {
        return (String)this.getParams().getValue((Object)name, 0);
    }

    public Collection<String> getParams(String name) {
        return (Collection)this.getParams().get((Object)name);
    }

    public ListValueMap<String, String> getParams() {
        if (null == this.paramsCache) {
            this.paramsCache = new ListValueMap();
            Charset charset = this.getCharset();
            String query = this.getQuery();
            if (StrUtil.isNotBlank((CharSequence)query)) {
                this.paramsCache.putAll(UrlQueryUtil.decodeQueryList((String)query, (Charset)charset));
            }
            if (this.isMultipart()) {
                this.paramsCache.putAll((Map)this.getMultipart().getParamListMap());
            } else {
                String body = this.getBody();
                if (StrUtil.isNotBlank((CharSequence)body)) {
                    this.paramsCache.putAll(UrlQueryUtil.decodeQueryList((String)body, (Charset)charset));
                }
            }
        }
        return this.paramsCache;
    }

    public String getClientIP(String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return this.getClientIPByHeader(headers);
    }

    public String getClientIPByHeader(String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = this.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = this.httpExchange.getRemoteAddress().getHostName();
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }

    public MultipartFormData getMultipart() throws IORuntimeException {
        if (null == this.multipartFormDataCache) {
            this.multipartFormDataCache = this.parseMultipart(new UploadSetting());
        }
        return this.multipartFormDataCache;
    }

    public MultipartFormData parseMultipart(UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream(this.getBodyStream(), this.getCharset());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return formData;
    }
}

