/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.useragent;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.useragent.Browser;
import org.dromara.hutool.http.useragent.BrowserEngine;
import org.dromara.hutool.http.useragent.OS;
import org.dromara.hutool.http.useragent.Platform;
import org.dromara.hutool.http.useragent.UserAgent;

public class UserAgentParser {
    public static UserAgent parse(String userAgentString) {
        if (StrUtil.isBlank((CharSequence)userAgentString)) {
            return null;
        }
        UserAgent userAgent = new UserAgent();
        Browser browser = UserAgentParser.parseBrowser(userAgentString);
        userAgent.setBrowser(browser);
        userAgent.setVersion(browser.getVersion(userAgentString));
        BrowserEngine engine = UserAgentParser.parseEngine(userAgentString);
        userAgent.setEngine(engine);
        userAgent.setEngineVersion(engine.getVersion(userAgentString));
        OS os = UserAgentParser.parseOS(userAgentString);
        userAgent.setOs(os);
        userAgent.setOsVersion(os.getVersion(userAgentString));
        Platform platform = UserAgentParser.parsePlatform(userAgentString);
        userAgent.setPlatform(platform);
        userAgent.setMobile(platform.isMobile() || browser.isMobile());
        return userAgent;
    }

    private static Browser parseBrowser(String userAgentString) {
        for (Browser browser : Browser.browers) {
            if (!browser.isMatch(userAgentString)) continue;
            return browser;
        }
        return Browser.Unknown;
    }

    private static BrowserEngine parseEngine(String userAgentString) {
        for (BrowserEngine engine : BrowserEngine.engines) {
            if (!engine.isMatch(userAgentString)) continue;
            return engine;
        }
        return BrowserEngine.Unknown;
    }

    private static OS parseOS(String userAgentString) {
        for (OS os : OS.oses) {
            if (!os.isMatch(userAgentString)) continue;
            return os;
        }
        return OS.Unknown;
    }

    private static Platform parsePlatform(String userAgentString) {
        for (Platform platform : Platform.platforms) {
            if (!platform.isMatch(userAgentString)) continue;
            return platform;
        }
        return Platform.Unknown;
    }
}

