/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http;

import java.nio.charset.Charset;
import java.util.Map;
import org.dromara.hutool.core.net.url.UrlQueryUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.engine.ClientEngineFactory;
import org.dromara.hutool.http.meta.Method;
import org.dromara.hutool.http.server.SimpleServer;

public class HttpUtil {
    public static boolean isHttps(String url) {
        return StrUtil.startWithIgnoreCase((CharSequence)url, (CharSequence)"https:");
    }

    public static boolean isHttp(String url) {
        return StrUtil.startWithIgnoreCase((CharSequence)url, (CharSequence)"http:");
    }

    public static String get(String urlString, Charset customCharset) {
        return HttpUtil.send(Request.of(urlString).charset(customCharset)).bodyStr();
    }

    public static String get(String urlString) {
        return HttpUtil.get(urlString, HttpGlobalConfig.getTimeout());
    }

    public static String get(String urlString, int timeout) {
        return ClientEngineFactory.getEngine().init(ClientConfig.of().setConnectionTimeout(timeout).setReadTimeout(timeout)).send(Request.of(urlString)).bodyStr();
    }

    public static String get(String urlString, Map<String, Object> paramMap) {
        return HttpUtil.send(Request.of(urlString).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpUtil.send(Request.of(urlString).method(Method.POST).form(paramMap)).bodyStr();
    }

    public static String post(String urlString, String body) {
        return HttpUtil.send(Request.of(urlString).method(Method.POST).body(body)).bodyStr();
    }

    public static Response send(Request request) {
        return ClientEngineFactory.getEngine().send(request);
    }

    public static String urlWithForm(String url, Map<String, Object> form, Charset charset, boolean isEncodeParams) {
        if (isEncodeParams && StrUtil.contains((CharSequence)url, (char)'?')) {
            url = UrlQueryUtil.encodeQuery((String)url, (Charset)charset);
        }
        return HttpUtil.urlWithForm(url, UrlQueryUtil.toQuery(form, (Charset)charset), charset, false);
    }

    public static String urlWithForm(String url, String queryString, Charset charset, boolean isEncode) {
        if (StrUtil.isBlank((CharSequence)queryString)) {
            if (StrUtil.contains((CharSequence)url, (char)'?')) {
                return isEncode ? UrlQueryUtil.encodeQuery((String)url, (Charset)charset) : url;
            }
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url.length() + queryString.length() + 16);
        int qmIndex = url.indexOf(63);
        if (qmIndex > 0) {
            urlBuilder.append(isEncode ? UrlQueryUtil.encodeQuery((String)url, (Charset)charset) : url);
            if (!StrUtil.endWith((CharSequence)url, (char)'&')) {
                urlBuilder.append('&');
            }
        } else {
            urlBuilder.append(url);
            if (qmIndex < 0) {
                urlBuilder.append('?');
            }
        }
        urlBuilder.append(isEncode ? UrlQueryUtil.encodeQuery((String)queryString, (Charset)charset) : queryString);
        return urlBuilder.toString();
    }

    public static SimpleServer createServer(int port) {
        return new SimpleServer(port);
    }
}

